/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.blockbuster_pack.client.gui.trackers.GuiBaseTracker;
import mchorse.blockbuster_pack.morphs.TrackerMorph;
import mchorse.blockbuster_pack.trackers.BaseTracker;
import mchorse.blockbuster_pack.trackers.TrackerRegistry;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;

public class GuiTrackerMorph
extends GuiAbstractMorph<TrackerMorph> {
    public GuiTrackerMorph(Minecraft mc) {
        super(mc);
        this.defaultPanel = new GuiTrackerMorphPanel(mc, this);
        this.registerPanel(this.defaultPanel, IKey.lang((String)"metamorph.gui.edit"), BBIcons.EDITOR);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof TrackerMorph;
    }

    public static class GuiTrackerMorphPanel
    extends GuiMorphPanel<TrackerMorph, GuiTrackerMorph> {
        public GuiCirculateElement type;
        public GuiToggleElement hidden;
        public GuiDelegateElement<GuiBaseTracker> trackerPanel;
        private List<String> trackers;

        public GuiTrackerMorphPanel(Minecraft mc, GuiTrackerMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            GuiLabel typeTitle = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.tracker_morph.type.title"));
            this.type = new GuiCirculateElement(mc, element -> {
                BaseTracker tracker = ((TrackerMorph)this.morph).tracker;
                Class<? extends BaseTracker> clazz = TrackerRegistry.ID_TO_CLASS.get(this.trackers.get(element.getValue()));
                if (clazz != null) {
                    try {
                        ((TrackerMorph)this.morph).tracker = clazz.newInstance();
                        ((TrackerMorph)this.morph).tracker.copy(tracker);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                this.updateTracker();
            });
            this.trackers = ImmutableList.copyOf(TrackerRegistry.ID_TO_CLASS.keySet());
            for (String tracker : this.trackers) {
                this.type.addLabel(IKey.lang((String)("blockbuster.gui.tracker_morph.type." + tracker)));
            }
            this.hidden = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.tracker_morph.hidden"), element -> {
                ((TrackerMorph)this.morph).hidden = element.isToggled();
            });
            GuiElement elements = Elements.column((Minecraft)mc, (int)10, (int)10, (GuiElement[])new GuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.tracker_morph.type.title")), this.type, this.hidden});
            elements.flex().relative((GuiElement)this).xy(0, 0).w(170);
            this.trackerPanel = new GuiDelegateElement(mc, null);
            this.trackerPanel.flex().relative(elements).x(0).y(1.0f).wTo((IResizer)this.area, 1.0f).hTo((IResizer)this.area, 1.0f);
            this.add(new IGuiElement[]{elements, this.trackerPanel});
        }

        public void fillData(TrackerMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.hidden.toggled(morph.hidden);
            this.updateTracker();
        }

        private void updateTracker() {
            this.trackerPanel.setDelegate(null);
            this.type.setValue(this.trackers.size());
            if (((TrackerMorph)this.morph).tracker != null) {
                this.type.setValue(this.trackers.indexOf(TrackerRegistry.CLASS_TO_ID.get(((TrackerMorph)this.morph).tracker.getClass())));
                this.trackerPanel.setDelegate((GuiElement)TrackerRegistry.CLIENT.get(((TrackerMorph)this.morph).tracker.getClass()));
            }
            if (this.trackerPanel.delegate != null) {
                ((GuiBaseTracker)this.trackerPanel.delegate).fill(((TrackerMorph)this.morph).tracker);
            }
        }
    }
}

