/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.Objects;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import javax.vecmath.Vector4f;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.client.textures.GifTexture;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ImageMorph
extends AbstractMorph
implements IAnimationProvider,
ISyncableMorph {
    public static final Matrix4f matrix = new Matrix4f();
    public static final Vector4d pos = new Vector4d();
    public static final Vector4d uv = new Vector4d();
    public static final Vector4d finalUv = new Vector4d();
    public ResourceLocation texture;
    public boolean shaded = true;
    public boolean lighting = true;
    public boolean billboard = false;
    public Vector4f crop = new Vector4f();
    public boolean resizeCrop;
    public int color = -1;
    public float offsetX;
    public float offsetY;
    public float rotation;
    public ModelTransform pose = new ModelTransform();
    public boolean keying;
    public boolean shadow = true;
    public ImageAnimation animation = new ImageAnimation();
    public ImageProperties image = new ImageProperties();

    public ImageMorph() {
        this.name = "blockbuster.image";
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        if (previous instanceof ImageMorph) {
            ImageMorph image = (ImageMorph)previous;
            this.animation.last = new ImageProperties();
            this.animation.last.from(image);
        } else {
            this.animation.last = new ImageProperties();
            this.animation.last.from(this);
        }
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return I18n.func_135052_a((String)"blockbuster.morph.image", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        if (this.texture == null) {
            return;
        }
        float partial = Minecraft.func_71410_x().func_184121_ak();
        this.updateAnimation(partial);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)((float)y - scale / 2.0f), (float)0.0f);
        GL11.glScalef((float)-1.5f, (float)1.5f, (float)1.5f);
        this.renderPicture(scale, player.field_70173_aa, partial);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!this.shadow && ReflectionUtils.isOptifineShadowPass()) {
            return;
        }
        if (this.texture == null) {
            return;
        }
        this.updateAnimation(partialTicks);
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        boolean defaultPose = this.image.pose.isDefault();
        GlStateManager.func_179091_B();
        if (!this.shaded) {
            RenderHelper.func_74518_a();
        }
        if (!this.lighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (!defaultPose) {
            this.image.pose.applyTranslate();
            this.image.pose.applyRotate();
        }
        if (this.billboard) {
            Matrix4f matrix4f = MatrixUtils.readModelView((Matrix4f)matrix);
            Vector4f zero = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            matrix4f.transform((Tuple4f)zero);
            matrix4f.setIdentity();
            matrix4f.setTranslation(new Vector3f(zero.x, zero.y, zero.z));
            matrix4f.transpose();
            MatrixUtils.loadModelView((Matrix4f)matrix4f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            float entityPitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            GL11.glRotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f - entityPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (!defaultPose) {
            this.image.pose.applyScale();
        }
        this.renderPicture(1.0f, entity.field_70173_aa, partialTicks);
        GL11.glPopMatrix();
        if (!this.shaded) {
            GlStateManager.func_179145_e();
            GlStateManager.func_179085_a((int)0);
            GlStateManager.func_179085_a((int)1);
            GlStateManager.func_179142_g();
        }
        if (!this.lighting) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        }
        GlStateManager.func_179101_C();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateAnimation(float partialTicks) {
        if (this.animation.isInProgress()) {
            this.image.from(this);
            this.animation.apply(this.image, partialTicks);
        } else {
            this.image.from(this);
        }
    }

    private void renderPicture(float scale, int ticks, float partialTicks) {
        boolean textureMatrix;
        GifTexture.bindTexture(this.texture, ticks, partialTicks);
        float w = this.getWidth();
        float h = this.getHeight();
        float ow = w;
        float oh = h;
        ImageMorph.uv.x = (double)this.image.crop.x / (double)w;
        ImageMorph.uv.y = 1.0 - (double)this.image.crop.z / (double)w;
        ImageMorph.uv.z = (double)this.image.crop.y / (double)h;
        ImageMorph.uv.w = 1.0 - (double)this.image.crop.w / (double)h;
        finalUv.set((Tuple4d)uv);
        if (this.resizeCrop) {
            finalUv.set(0.0, 1.0, 0.0, 1.0);
            w = w - this.image.crop.x - this.image.crop.z;
            h = h - this.image.crop.y - this.image.crop.w;
        }
        double ratioX = w > h ? (double)h / (double)w : 1.0;
        double ratioY = h > w ? (double)w / (double)h : 1.0;
        pos.set(-(ImageMorph.finalUv.x - 0.5) * ratioY, -(ImageMorph.finalUv.y - 0.5) * ratioY, (ImageMorph.finalUv.z - 0.5) * ratioX, (ImageMorph.finalUv.w - 0.5) * ratioX);
        pos.scale((double)scale);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        if (this.keying) {
            GlStateManager.func_187398_d((int)32779);
            GlStateManager.func_179112_b((int)0, (int)0);
        } else {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = textureMatrix = this.image.x != 0.0f || this.image.y != 0.0f || this.image.rotation != 0.0f;
        if (textureMatrix) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179109_b((float)(this.image.x / ow), (float)(this.image.y / oh), (float)0.0f);
            GlStateManager.func_179114_b((float)this.image.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        Color color = this.image.color;
        buffer.func_181662_b(ImageMorph.pos.x, ImageMorph.pos.z, 0.0).func_187315_a(ImageMorph.uv.x, ImageMorph.uv.z).func_181666_a(color.r, color.g, color.b, color.a).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(ImageMorph.pos.y, ImageMorph.pos.z, 0.0).func_187315_a(ImageMorph.uv.y, ImageMorph.uv.z).func_181666_a(color.r, color.g, color.b, color.a).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(ImageMorph.pos.y, ImageMorph.pos.w, 0.0).func_187315_a(ImageMorph.uv.y, ImageMorph.uv.w).func_181666_a(color.r, color.g, color.b, color.a).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(ImageMorph.pos.x, ImageMorph.pos.w, 0.0).func_187315_a(ImageMorph.uv.x, ImageMorph.uv.w).func_181666_a(color.r, color.g, color.b, color.a).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (textureMatrix) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
        }
        if (this.keying) {
            GlStateManager.func_187398_d((int)32774);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void update(EntityLivingBase target) {
        super.update(target);
        this.animation.update();
    }

    public int getWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public int getHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public AbstractMorph create() {
        return new ImageMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof ImageMorph) {
            ImageMorph morph = (ImageMorph)from;
            this.texture = RLUtils.clone((ResourceLocation)morph.texture);
            this.shaded = morph.shaded;
            this.lighting = morph.lighting;
            this.billboard = morph.billboard;
            this.crop.set((Tuple4f)morph.crop);
            this.resizeCrop = morph.resizeCrop;
            this.color = morph.color;
            this.offsetX = morph.offsetX;
            this.offsetY = morph.offsetY;
            this.rotation = morph.rotation;
            this.pose.copy(morph.pose);
            this.keying = morph.keying;
            this.shadow = morph.shadow;
            this.animation.copy(morph.animation);
            this.animation.reset();
        }
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof ImageMorph) {
            ImageMorph image = (ImageMorph)((Object)obj);
            result = result && Objects.equals(image.texture, this.texture);
            result = result && image.shaded == this.shaded;
            result = result && image.lighting == this.lighting;
            result = result && image.billboard == this.billboard;
            result = result && image.crop.equals((Tuple4f)this.crop);
            result = result && image.resizeCrop == this.resizeCrop;
            result = result && image.color == this.color;
            result = result && image.offsetX == this.offsetX;
            result = result && image.offsetY == this.offsetY;
            result = result && image.rotation == this.rotation;
            result = result && Objects.equals(image.pose, this.pose);
            result = result && image.keying == this.keying;
            result = result && image.shadow == this.shadow;
            result = result && Objects.equals((Object)image.animation, (Object)this.animation);
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof ImageMorph) {
            ImageMorph image = (ImageMorph)morph;
            this.mergeBasic(morph);
            if (!image.animation.ignored) {
                this.animation.merge(this, image);
                this.copy(image);
                this.animation.progress = 0;
            }
            return true;
        }
        return super.canMerge(morph);
    }

    public float getWidth(EntityLivingBase target) {
        return 0.0f;
    }

    public float getHeight(EntityLivingBase target) {
        return 0.0f;
    }

    public void reset() {
        super.reset();
        this.animation.reset();
    }

    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound animation;
        super.toNBT(tag);
        if (this.texture != null) {
            tag.func_74782_a("Texture", RLUtils.writeNbt((ResourceLocation)this.texture));
        }
        if (!this.shaded) {
            tag.func_74757_a("Shaded", this.shaded);
        }
        if (!this.lighting) {
            tag.func_74757_a("Lighting", this.lighting);
        }
        if (this.billboard) {
            tag.func_74757_a("Billboard", this.billboard);
        }
        if (this.crop.x != 0.0f) {
            tag.func_74768_a("Left", (int)this.crop.x);
        }
        if (this.crop.z != 0.0f) {
            tag.func_74768_a("Right", (int)this.crop.z);
        }
        if (this.crop.y != 0.0f) {
            tag.func_74768_a("Top", (int)this.crop.y);
        }
        if (this.crop.w != 0.0f) {
            tag.func_74768_a("Bottom", (int)this.crop.w);
        }
        if (this.resizeCrop) {
            tag.func_74757_a("ResizeCrop", this.resizeCrop);
        }
        if (this.color != -1) {
            tag.func_74768_a("Color", this.color);
        }
        if (this.offsetX != 0.0f) {
            tag.func_74776_a("OffsetX", this.offsetX);
        }
        if (this.offsetY != 0.0f) {
            tag.func_74776_a("OffsetY", this.offsetY);
        }
        if (this.rotation != 0.0f) {
            tag.func_74776_a("Rotation", this.rotation);
        }
        if (!this.pose.isDefault()) {
            tag.func_74782_a("Pose", (NBTBase)this.pose.toNBT());
        }
        if (this.keying) {
            tag.func_74757_a("Keying", this.keying);
        }
        if (!this.shadow) {
            tag.func_74757_a("Shadow", this.shadow);
        }
        if (!(animation = this.animation.toNBT()).func_82582_d()) {
            tag.func_74782_a("Animation", (NBTBase)animation);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Texture")) {
            this.texture = RLUtils.create((NBTBase)tag.func_74781_a("Texture"));
        }
        if (tag.func_74764_b("Shaded")) {
            this.shaded = tag.func_74767_n("Shaded");
        }
        if (tag.func_74764_b("Lighting")) {
            this.lighting = tag.func_74767_n("Lighting");
        }
        if (tag.func_74764_b("Billboard")) {
            this.billboard = tag.func_74767_n("Billboard");
        }
        if (tag.func_74764_b("Left")) {
            this.crop.x = tag.func_74762_e("Left");
        }
        if (tag.func_74764_b("Right")) {
            this.crop.z = tag.func_74762_e("Right");
        }
        if (tag.func_74764_b("Top")) {
            this.crop.y = tag.func_74762_e("Top");
        }
        if (tag.func_74764_b("Bottom")) {
            this.crop.w = tag.func_74762_e("Bottom");
        }
        if (tag.func_74764_b("ResizeCrop")) {
            this.resizeCrop = tag.func_74767_n("ResizeCrop");
        }
        if (tag.func_74764_b("Color")) {
            this.color = tag.func_74762_e("Color");
        }
        if (tag.func_74764_b("OffsetX")) {
            this.offsetX = tag.func_74760_g("OffsetX");
        }
        if (tag.func_74764_b("OffsetY")) {
            this.offsetY = tag.func_74760_g("OffsetY");
        }
        if (tag.func_74764_b("Rotation")) {
            this.rotation = tag.func_74760_g("Rotation");
        }
        if (tag.func_74764_b("Animation")) {
            this.animation.fromNBT(tag.func_74775_l("Animation"));
        }
        if (tag.func_74764_b("Pose")) {
            this.pose.fromNBT(tag.func_74775_l("Pose"));
        }
        if (tag.func_74764_b("Keying")) {
            this.keying = tag.func_74767_n("Keying");
        }
        if (tag.func_74764_b("Shadow")) {
            this.shadow = tag.func_74767_n("Shadow");
        }
        if (tag.func_74764_b("Scale")) {
            float scale;
            this.pose.scale[0] = scale = tag.func_74760_g("Scale");
            this.pose.scale[1] = scale;
            this.pose.scale[2] = scale;
        }
    }

    public static class ImageProperties {
        public Color color = new Color();
        public Vector4f crop = new Vector4f();
        public ModelTransform pose = new ModelTransform();
        public float x;
        public float y;
        public float rotation;

        public void from(ImageMorph morph) {
            this.color.set(morph.color, true);
            this.crop.set((Tuple4f)morph.crop);
            this.pose.copy(morph.pose);
            this.x = morph.offsetX;
            this.y = morph.offsetY;
            this.rotation = morph.rotation;
        }
    }

    public static class ImageAnimation
    extends Animation {
        public ImageProperties last;

        public void merge(ImageMorph last, ImageMorph next) {
            this.merge(next.animation);
            if (this.last == null) {
                this.last = new ImageProperties();
            }
            this.last.from(last);
        }

        public void apply(ImageProperties properties, float partialTicks) {
            if (this.last == null) {
                return;
            }
            float factor = this.getFactor(partialTicks);
            properties.color.r = this.interp.interpolate(this.last.color.r, properties.color.r, factor);
            properties.color.g = this.interp.interpolate(this.last.color.g, properties.color.g, factor);
            properties.color.b = this.interp.interpolate(this.last.color.b, properties.color.b, factor);
            properties.color.a = this.interp.interpolate(this.last.color.a, properties.color.a, factor);
            properties.crop.x = (int)this.interp.interpolate(this.last.crop.x, properties.crop.x, factor);
            properties.crop.y = (int)this.interp.interpolate(this.last.crop.y, properties.crop.y, factor);
            properties.crop.z = (int)this.interp.interpolate(this.last.crop.z, properties.crop.z, factor);
            properties.crop.w = (int)this.interp.interpolate(this.last.crop.w, properties.crop.w, factor);
            properties.pose.interpolate(this.last.pose, properties.pose, factor, this.interp);
            properties.x = this.interp.interpolate(this.last.x, properties.x, factor);
            properties.y = this.interp.interpolate(this.last.y, properties.y, factor);
            properties.rotation = this.interp.interpolate(this.last.rotation, properties.rotation, factor);
        }
    }
}

