/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.blockbuster_pack.morphs.SnowstormMorph;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ParticleMorph
extends AbstractMorph {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    private static final int[] EMPTY_ARGS = new int[0];
    public ParticleMode mode = ParticleMode.VANILLA;
    public int frequency = 2;
    public int duration = -1;
    public int delay = 0;
    public int cap = 2500;
    public EnumParticleTypes vanillaType = EnumParticleTypes.EXPLOSION_NORMAL;
    public double vanillaX;
    public double vanillaY;
    public double vanillaZ;
    public double vanillaDX = 0.1;
    public double vanillaDY = 0.1;
    public double vanillaDZ = 0.1;
    public double speed = 0.1;
    public int count = 10;
    public boolean localRotation = true;
    public int[] arguments = EMPTY_ARGS;
    public AbstractMorph morph;
    public MorphParticle.MovementType movementType = MorphParticle.MovementType.OUT;
    public boolean yaw = true;
    public boolean pitch = true;
    public boolean sequencer;
    public boolean random;
    public int fade = 10;
    public int lifeSpan = 50;
    public int maximum = 25;
    private Vector3d lastGlobal = new Vector3d();
    private Matrix3f lastRotation = new Matrix3f();
    private int tick;
    private List<MorphParticle> morphParticles = new ArrayList<MorphParticle>();
    private int morphIndex;
    public Random rand = new Random();

    public ParticleMorph() {
        this.name = "particle";
    }

    public AbstractMorph getMorph() {
        AbstractMorph morph = this.morph;
        if (this.sequencer && morph instanceof SequencerMorph) {
            SequencerMorph seq = (SequencerMorph)morph;
            morph = this.random ? seq.getRandom() : seq.get(this.morphIndex++ % seq.morphs.size());
        }
        return MorphUtils.copy((AbstractMorph)morph.copy());
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return I18n.func_135052_a((String)"blockbuster.morph.particle", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PARTICLE_TEXTURES);
        double factor = (double)(System.currentTimeMillis() % 1000L) / 500.0 - 1.0;
        int size = (int)(scale * 1.5f);
        int offset = (int)(Math.floor(Math.abs(factor * factor) * 8.0) * 8.0);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        Gui.func_152125_a((int)(x - size / 2), (int)(y - size + size / 8), (float)offset, (float)0.0f, (int)8, (int)8, (int)size, (int)size, (float)128.0f, (float)128.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entityLivingBase, double x, double y, double z, float yaw, float partialTicks) {
        if (GuiModelRenderer.isRendering()) {
            return;
        }
        if (MatrixUtils.matrix != null) {
            Matrix4f parent = new Matrix4f(MatrixUtils.matrix);
            Matrix4f matrix4f = MatrixUtils.readModelView((Matrix4f)SnowstormMorph.getMatrix());
            parent.invert();
            parent.mul(matrix4f);
            Vector4f zero = SnowstormMorph.calculateGlobal(parent, entityLivingBase, 0.0f, 0.0f, 0.0f, partialTicks);
            Vector3f ax = new Vector3f(parent.m00, parent.m01, parent.m02);
            Vector3f ay = new Vector3f(parent.m10, parent.m11, parent.m12);
            Vector3f az = new Vector3f(parent.m20, parent.m21, parent.m22);
            ax.normalize();
            ay.normalize();
            az.normalize();
            this.lastRotation.setRow(0, ax);
            this.lastRotation.setRow(1, ay);
            this.lastRotation.setRow(2, az);
            this.lastGlobal.x = zero.x;
            this.lastGlobal.y = zero.y;
            this.lastGlobal.z = zero.z;
        } else {
            this.lastRotation.setIdentity();
            this.lastGlobal.x = Interpolations.lerp((double)entityLivingBase.field_70169_q, (double)entityLivingBase.field_70165_t, (double)partialTicks);
            this.lastGlobal.y = Interpolations.lerp((double)entityLivingBase.field_70167_r, (double)entityLivingBase.field_70163_u, (double)partialTicks);
            this.lastGlobal.z = Interpolations.lerp((double)entityLivingBase.field_70166_s, (double)entityLivingBase.field_70161_v, (double)partialTicks);
        }
        if (!this.morphParticles.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            for (MorphParticle particle : this.morphParticles) {
                particle.render(entityLivingBase, partialTicks);
            }
            GL11.glPopMatrix();
        }
    }

    public void update(EntityLivingBase target) {
        boolean alive;
        super.update(target);
        boolean bl = alive = this.duration < 0 || this.tick < this.duration;
        if (this.frequency != 0 && this.tick >= this.delay && this.tick % this.frequency == 0 && alive) {
            boolean morphCap;
            int max = this.cap;
            int particlesPerSecond = (int)(20.0f / (float)this.frequency * (float)this.count);
            boolean vanillaCap = this.mode == ParticleMode.VANILLA && particlesPerSecond <= max;
            boolean bl2 = morphCap = this.mode == ParticleMode.MORPH && this.maximum <= max;
            if ((vanillaCap || morphCap) && target.field_70170_p.field_72995_K) {
                if (this.mode == ParticleMode.VANILLA && this.vanillaType != null) {
                    double x = this.lastGlobal.x + this.vanillaX;
                    double y = this.lastGlobal.y + this.vanillaY;
                    double z = this.lastGlobal.z + this.vanillaZ;
                    Vector3f vector = new Vector3f(0.0f, 0.0f, 0.0f);
                    for (int i = 0; i < this.count; ++i) {
                        double dx = this.rand.nextGaussian() * this.vanillaDX;
                        double dy = this.rand.nextGaussian() * this.vanillaDY;
                        double dz = this.rand.nextGaussian() * this.vanillaDZ;
                        double sx = this.rand.nextGaussian() * this.speed;
                        double sy = this.rand.nextGaussian() * this.speed;
                        double sz = this.rand.nextGaussian() * this.speed;
                        if (this.localRotation) {
                            vector.set((float)dx, (float)dy, (float)dz);
                            this.lastRotation.transform((Tuple3f)vector);
                            dx = vector.x;
                            dy = vector.y;
                            dz = vector.z;
                        }
                        try {
                            target.field_70170_p.func_175682_a(this.vanillaType, true, x + dx, y + dy, z + dz, sx, sy, sz, this.arguments);
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                } else if (this.mode == ParticleMode.MORPH && this.morph != null && this.morphParticles.size() < this.maximum) {
                    for (int i = 0; i < this.count && this.morphParticles.size() < this.maximum; ++i) {
                        this.morphParticles.add(new MorphParticle(this));
                    }
                }
            }
        }
        if (target.field_70170_p.field_72995_K) {
            Iterator<MorphParticle> it = this.morphParticles.iterator();
            while (it.hasNext()) {
                MorphParticle particle = it.next();
                particle.update(target);
                if (!particle.isDead()) continue;
                it.remove();
            }
        }
        ++this.tick;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof ParticleMorph) {
            ParticleMorph particle = (ParticleMorph)((Object)obj);
            result = result && this.mode == particle.mode;
            result = result && this.frequency == particle.frequency;
            result = result && this.duration == particle.duration;
            result = result && this.delay == particle.delay;
            result = result && this.cap == particle.cap;
            result = result && this.vanillaType == particle.vanillaType;
            result = result && this.vanillaX == particle.vanillaX;
            result = result && this.vanillaY == particle.vanillaY;
            result = result && this.vanillaZ == particle.vanillaZ;
            result = result && this.vanillaDX == particle.vanillaDX;
            result = result && this.vanillaDY == particle.vanillaDY;
            result = result && this.vanillaDZ == particle.vanillaDZ;
            result = result && this.speed == particle.speed;
            result = result && this.count == particle.count;
            result = result && this.localRotation == particle.localRotation;
            boolean sameArgs = false;
            if (this.arguments.length == particle.arguments.length) {
                int same = 0;
                for (int i = 0; i < this.arguments.length; ++i) {
                    if (this.arguments[i] != particle.arguments[i]) continue;
                    ++same;
                }
                sameArgs = same == this.arguments.length;
            }
            result = result && sameArgs;
            result = result && Objects.equals(this.morph, particle.morph);
            result = result && this.movementType == particle.movementType;
            result = result && this.yaw == particle.yaw;
            result = result && this.pitch == particle.pitch;
            result = result && this.sequencer == particle.sequencer;
            result = result && this.random == particle.random;
            result = result && this.fade == particle.fade;
            result = result && this.lifeSpan == particle.lifeSpan;
            result = result && this.maximum == particle.maximum;
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof ParticleMorph) {
            this.copy(morph);
            this.morphIndex = 0;
            this.tick = 0;
            return true;
        }
        return super.canMerge(morph);
    }

    public AbstractMorph create() {
        return new ParticleMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof ParticleMorph) {
            ParticleMorph morph = (ParticleMorph)from;
            this.mode = morph.mode;
            this.frequency = morph.frequency;
            this.duration = morph.duration;
            this.delay = morph.delay;
            this.cap = morph.cap;
            this.vanillaType = morph.vanillaType;
            this.vanillaX = morph.vanillaX;
            this.vanillaY = morph.vanillaY;
            this.vanillaZ = morph.vanillaZ;
            this.vanillaDX = morph.vanillaDX;
            this.vanillaDY = morph.vanillaDY;
            this.vanillaDZ = morph.vanillaDZ;
            this.speed = morph.speed;
            this.count = morph.count;
            this.localRotation = morph.localRotation;
            this.arguments = morph.arguments;
            this.morph = MorphUtils.copy((AbstractMorph)morph.morph);
            this.movementType = morph.movementType;
            this.yaw = morph.yaw;
            this.pitch = morph.pitch;
            this.sequencer = morph.sequencer;
            this.random = morph.random;
            this.fade = morph.fade;
            this.lifeSpan = morph.lifeSpan;
            this.maximum = morph.maximum;
        }
    }

    public float getWidth(EntityLivingBase entityLivingBase) {
        return 0.6f;
    }

    public float getHeight(EntityLivingBase entityLivingBase) {
        return 1.8f;
    }

    public void reset() {
        super.reset();
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Mode")) {
            ParticleMode particleMode = this.mode = tag.func_74779_i("Mode").equals(ParticleMode.MORPH.type) ? ParticleMode.MORPH : ParticleMode.VANILLA;
        }
        if (tag.func_74764_b("Frequency")) {
            this.frequency = tag.func_74762_e("Frequency");
        }
        if (tag.func_74764_b("Duration")) {
            this.duration = tag.func_74762_e("Duration");
        }
        if (tag.func_74764_b("Delay")) {
            this.delay = tag.func_74762_e("Delay");
        }
        if (tag.func_74764_b("Cap")) {
            this.cap = tag.func_74762_e("Cap");
        }
        if (tag.func_74764_b("Type")) {
            this.vanillaType = EnumParticleTypes.func_186831_a((String)tag.func_74779_i("Type"));
        }
        if (tag.func_74764_b("X")) {
            this.vanillaX = tag.func_74769_h("X");
        }
        if (tag.func_74764_b("Y")) {
            this.vanillaY = tag.func_74769_h("Y");
        }
        if (tag.func_74764_b("Z")) {
            this.vanillaZ = tag.func_74769_h("Z");
        }
        if (tag.func_74764_b("DX")) {
            this.vanillaDX = tag.func_74769_h("DX");
        }
        if (tag.func_74764_b("DY")) {
            this.vanillaDY = tag.func_74769_h("DY");
        }
        if (tag.func_74764_b("DZ")) {
            this.vanillaDZ = tag.func_74769_h("DZ");
        }
        if (tag.func_74764_b("Speed")) {
            this.speed = tag.func_74769_h("Speed");
        }
        if (tag.func_74764_b("Count")) {
            this.count = tag.func_74762_e("Count");
        }
        if (tag.func_74764_b("LocalRotation")) {
            this.localRotation = tag.func_74767_n("LocalRotation");
        }
        if (tag.func_74764_b("Args")) {
            this.arguments = tag.func_74759_k("Args");
        }
        if (tag.func_74764_b("Morph")) {
            this.morph = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph"));
        }
        if (tag.func_74764_b("Movement")) {
            this.movementType = MorphParticle.MovementType.getType(tag.func_74779_i("Movement"));
        }
        if (tag.func_74764_b("Yaw")) {
            this.yaw = tag.func_74767_n("Yaw");
        }
        if (tag.func_74764_b("Pitch")) {
            this.pitch = tag.func_74767_n("Pitch");
        }
        if (tag.func_74764_b("Sequencer")) {
            this.sequencer = tag.func_74767_n("Sequencer");
        }
        if (tag.func_74764_b("Random")) {
            this.random = tag.func_74767_n("Random");
        }
        if (tag.func_74764_b("Fade")) {
            this.fade = tag.func_74762_e("Fade");
        }
        if (tag.func_74764_b("Life")) {
            this.lifeSpan = tag.func_74762_e("Life");
        }
        if (tag.func_74764_b("Max")) {
            this.maximum = tag.func_74762_e("Max");
        }
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.mode != ParticleMode.VANILLA) {
            tag.func_74778_a("Mode", this.mode.type);
        }
        if (this.frequency != 2) {
            tag.func_74768_a("Frequency", this.frequency);
        }
        if (this.duration != -1) {
            tag.func_74768_a("Duration", this.duration);
        }
        if (this.delay != 0) {
            tag.func_74768_a("Delay", this.delay);
        }
        if (this.cap != 2500) {
            tag.func_74768_a("Cap", this.cap);
        }
        if (this.vanillaType != EnumParticleTypes.EXPLOSION_NORMAL) {
            tag.func_74778_a("Type", this.vanillaType.func_179346_b());
        }
        if (this.vanillaX != 0.0) {
            tag.func_74780_a("X", this.vanillaX);
        }
        if (this.vanillaY != 0.0) {
            tag.func_74780_a("Y", this.vanillaY);
        }
        if (this.vanillaZ != 0.0) {
            tag.func_74780_a("Z", this.vanillaZ);
        }
        if (this.vanillaDX != 0.1) {
            tag.func_74780_a("DX", this.vanillaDX);
        }
        if (this.vanillaDY != 0.1) {
            tag.func_74780_a("DY", this.vanillaDY);
        }
        if (this.vanillaDZ != 0.1) {
            tag.func_74780_a("DZ", this.vanillaDZ);
        }
        if (this.speed != 0.1) {
            tag.func_74780_a("Speed", this.speed);
        }
        if (this.count != 10) {
            tag.func_74768_a("Count", this.count);
        }
        if (!this.localRotation) {
            tag.func_74757_a("LocalRotation", this.localRotation);
        }
        if (this.arguments.length != 0) {
            tag.func_74783_a("Args", this.arguments);
        }
        if (this.morph != null) {
            NBTTagCompound morph = new NBTTagCompound();
            this.morph.toNBT(morph);
            tag.func_74782_a("Morph", (NBTBase)morph);
        }
        if (this.movementType != MorphParticle.MovementType.OUT) {
            tag.func_74778_a("Movement", this.movementType.id);
        }
        if (!this.yaw) {
            tag.func_74757_a("Yaw", this.yaw);
        }
        if (!this.pitch) {
            tag.func_74757_a("Pitch", this.pitch);
        }
        if (this.sequencer) {
            tag.func_74757_a("Sequencer", this.sequencer);
        }
        if (this.random) {
            tag.func_74757_a("Random", this.random);
        }
        if (this.fade != 10) {
            tag.func_74768_a("Fade", this.fade);
        }
        if (this.lifeSpan != 50) {
            tag.func_74768_a("Life", this.lifeSpan);
        }
        if (this.maximum != 25) {
            tag.func_74768_a("Max", this.maximum);
        }
    }

    public static enum ParticleMode {
        VANILLA("vanilla"),
        MORPH("morph");

        public final String type;

        private ParticleMode(String type) {
            this.type = type;
        }
    }

    public static class MorphParticle {
        public ParticleMorph parent;
        public AbstractMorph morph;
        public MovementType movementType;
        public float targetX;
        public float targetY;
        public float targetZ;
        public float x;
        public float y;
        public float z;
        public float prevX;
        public float prevY;
        public float prevZ;
        public float yaw;
        public float pitch;
        public float prevYaw;
        public float prevPitch;
        public int timer;

        public MorphParticle(ParticleMorph morph) {
            this.parent = morph;
            this.morph = morph.getMorph();
            this.movementType = morph.movementType;
            this.movementType.calculateInitial(this);
            this.timer = 1;
            this.movementType.calculate(this);
            this.calculateRotation();
            this.movementType.calculateInitial(this);
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
        }

        public void update(EntityLivingBase entity) {
            ++this.timer;
            this.prevX = this.x;
            this.prevY = this.y;
            this.prevZ = this.z;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.movementType.calculate(this);
            this.calculateRotation();
            this.morph.update(entity);
        }

        private void calculateRotation() {
            double dX = this.x - this.prevX;
            double dY = this.y - this.prevY;
            double dZ = this.z - this.prevZ;
            double horizontalDistance = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            this.yaw = (float)(180.0 - MathHelper.func_181159_b((double)dZ, (double)dX) * 180.0 / Math.PI) + 90.0f;
            this.pitch = (float)(MathHelper.func_181159_b((double)dY, (double)horizontalDistance) * 180.0 / Math.PI);
        }

        public void render(EntityLivingBase entity, float partialTicks) {
            GL11.glPushMatrix();
            double x = (double)Interpolations.lerp((float)this.prevX, (float)this.x, (float)partialTicks) + this.parent.vanillaX;
            double y = (double)Interpolations.lerp((float)this.prevY, (float)this.y, (float)partialTicks) + this.parent.vanillaY;
            double z = (double)Interpolations.lerp((float)this.prevZ, (float)this.z, (float)partialTicks) + this.parent.vanillaZ;
            double scale = Interpolations.envelope((float)((float)this.timer + partialTicks), (float)this.parent.lifeSpan, (float)this.parent.fade);
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            if (this.parent.yaw) {
                GlStateManager.func_179114_b((float)Interpolations.lerp((float)this.prevYaw, (float)this.yaw, (float)partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.parent.pitch) {
                GlStateManager.func_179114_b((float)Interpolations.lerp((float)this.prevPitch, (float)this.pitch, (float)partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.parent.yaw || this.parent.pitch) {
                float yaw = entity.field_70177_z;
                float pitch = entity.field_70125_A;
                float yawHead = entity.field_70759_as;
                float yawBody = entity.field_70761_aq;
                float prevYaw = entity.field_70126_B;
                float prevPitch = entity.field_70127_C;
                float prevYawHead = entity.field_70758_at;
                float prevYawBody = entity.field_70760_ar;
                entity.field_70126_B = 0.0f;
                entity.field_70177_z = 0.0f;
                entity.field_70758_at = 0.0f;
                entity.field_70759_as = 0.0f;
                entity.field_70127_C = 0.0f;
                entity.field_70125_A = 0.0f;
                entity.field_70760_ar = 0.0f;
                entity.field_70761_aq = 0.0f;
                this.morph.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks);
                entity.field_70177_z = yaw;
                entity.field_70125_A = pitch;
                entity.field_70759_as = yawHead;
                entity.field_70761_aq = yawBody;
                entity.field_70126_B = prevYaw;
                entity.field_70127_C = prevPitch;
                entity.field_70758_at = prevYawHead;
                entity.field_70760_ar = prevYawBody;
            } else {
                this.morph.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks);
            }
            GL11.glPopMatrix();
        }

        public boolean isDead() {
            return this.timer >= this.parent.lifeSpan;
        }

        public float getFactor() {
            return this.parent.lifeSpan == 0 ? 1.0f : (float)this.timer / (float)this.parent.lifeSpan;
        }

        public static enum MovementType {
            OUT("out"){

                @Override
                public void calculateInitial(MorphParticle particle) {
                    particle.targetX = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDX;
                    particle.targetY = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDY;
                    particle.targetZ = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDZ;
                    particle.prevX = 0.0f;
                    particle.x = 0.0f;
                    particle.prevY = 0.0f;
                    particle.y = 0.0f;
                    particle.prevZ = 0.0f;
                    particle.z = 0.0f;
                }

                @Override
                public void calculate(MorphParticle particle) {
                    float factor = particle.getFactor();
                    particle.x = Interpolations.lerp((float)0.0f, (float)particle.targetX, (float)factor);
                    particle.y = Interpolations.lerp((float)0.0f, (float)particle.targetY, (float)factor);
                    particle.z = Interpolations.lerp((float)0.0f, (float)particle.targetZ, (float)factor);
                }
            }
            ,
            IN("in"){

                @Override
                public void calculateInitial(MorphParticle particle) {
                    particle.x = particle.prevX = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDX;
                    particle.targetX = particle.prevX;
                    particle.y = particle.prevY = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDY;
                    particle.targetY = particle.prevY;
                    particle.z = particle.prevZ = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDZ;
                    particle.targetZ = particle.prevZ;
                }

                @Override
                public void calculate(MorphParticle particle) {
                    float factor = particle.getFactor();
                    particle.x = Interpolations.lerp((float)particle.targetX, (float)0.0f, (float)factor);
                    particle.y = Interpolations.lerp((float)particle.targetY, (float)0.0f, (float)factor);
                    particle.z = Interpolations.lerp((float)particle.targetZ, (float)0.0f, (float)factor);
                }
            }
            ,
            DROP("drop"){

                @Override
                public void calculateInitial(MorphParticle particle) {
                    particle.x = particle.prevX = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDX;
                    particle.y = particle.prevY = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDY;
                    particle.z = particle.prevZ = (particle.parent.rand.nextFloat() * 2.0f - 1.0f) * (float)particle.parent.vanillaDZ;
                }

                @Override
                public void calculate(MorphParticle particle) {
                    if (particle.targetY < 5.0f) {
                        particle.targetY += 0.02f;
                    }
                    particle.y -= particle.targetY;
                }
            };

            public final String id;

            public static MovementType getType(String id) {
                for (MovementType type : MovementType.values()) {
                    if (!type.id.equals(id)) continue;
                    return type;
                }
                return OUT;
            }

            private MovementType(String type) {
                this.id = type;
            }

            public abstract void calculateInitial(MorphParticle var1);

            public abstract void calculate(MorphParticle var1);
        }
    }
}

