/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.particles.BedrockLibrary;
import mchorse.blockbuster.client.particles.BedrockScheme;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SnowstormMorph
extends AbstractMorph {
    @SideOnly(value=Side.CLIENT)
    private static Matrix4f matrix;
    @SideOnly(value=Side.CLIENT)
    private static Vector4f vector;
    public String scheme = "";
    public Map<String, String> variables = new HashMap<String, String>();
    private BedrockEmitter emitter;
    public List<BedrockEmitter> lastEmitters;
    private long lastUpdate;
    private int lastAge = 0;

    public static Matrix4f getMatrix() {
        if (matrix == null) {
            matrix = new Matrix4f();
        }
        return matrix;
    }

    public static Vector4f getVector() {
        if (vector == null) {
            vector = new Vector4f();
        }
        return vector;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector4f calculateGlobal(Matrix4f matrix, EntityLivingBase entity, float x, float y, float z, float partial) {
        Vector4f vector4f = SnowstormMorph.getVector();
        vector4f.set(x, y, z, 1.0f);
        matrix.transform((Tuple4f)vector4f);
        vector4f.add((Tuple4f)new Vector4f((float)Interpolations.lerp((double)entity.field_70169_q, (double)entity.field_70165_t, (double)partial), (float)Interpolations.lerp((double)entity.field_70167_r, (double)entity.field_70163_u, (double)partial), (float)Interpolations.lerp((double)entity.field_70166_s, (double)entity.field_70161_v, (double)partial), 0.0f));
        return vector4f;
    }

    public SnowstormMorph() {
        this.name = "snowstorm";
    }

    public void replaceVariable(String name, String expression) {
        this.variables.put(name, expression);
        this.emitter.parseVariable(name, expression);
    }

    public BedrockEmitter getEmitter() {
        if (this.emitter == null) {
            this.setClientScheme(this.scheme);
        }
        return this.emitter;
    }

    public List<BedrockEmitter> getLastEmitters() {
        if (this.lastEmitters == null) {
            this.lastEmitters = new ArrayList<BedrockEmitter>();
        }
        return this.lastEmitters;
    }

    public void setScheme(String key) {
        this.scheme = key;
        if (this.emitter != null) {
            this.setClientScheme(key);
        }
    }

    private void setClientScheme(String key) {
        if (this.emitter != null) {
            this.getEmitter().running = false;
            this.getLastEmitters().add(this.getEmitter());
        }
        this.emitter = new BedrockEmitter();
        this.emitter.setScheme(this.getScheme(key), this.variables);
    }

    private BedrockScheme getScheme(String key) {
        return Blockbuster.proxy.particles.presets.get(key);
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return this.getEmitter().scheme != null ? this.getEmitter().scheme.identifier : this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer entityPlayer, int x, int y, float scale, float alpha) {
        this.getEmitter().renderOnScreen(x, y, scale);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase target, double x, double y, double z, float yaw, float partialTicks) {
        if (GuiModelRenderer.isRendering()) {
            return;
        }
        if (this.emitter != null && this.emitter.scheme != null && this.lastUpdate < BedrockLibrary.lastUpdate) {
            this.lastUpdate = BedrockLibrary.lastUpdate;
            if (this.emitter.scheme != this.getScheme(this.scheme)) {
                this.setClientScheme(this.scheme);
            }
        }
        BedrockEmitter emitter = this.getEmitter();
        if (MatrixUtils.matrix != null) {
            Matrix4f parent = new Matrix4f(MatrixUtils.matrix);
            Matrix4f matrix4f = MatrixUtils.readModelView((Matrix4f)SnowstormMorph.getMatrix());
            parent.invert();
            parent.mul(matrix4f);
            Vector4f zero = SnowstormMorph.calculateGlobal(parent, target, 0.0f, 0.0f, 0.0f, partialTicks);
            if (this.lastAge != this.age) {
                emitter.prevRotation.set(emitter.rotation);
                emitter.prevGlobal.set((Tuple3d)emitter.lastGlobal);
            }
            this.lastAge = this.age;
            emitter.lastGlobal.x = zero.x;
            emitter.lastGlobal.y = zero.y;
            emitter.lastGlobal.z = zero.z;
            emitter.rotation.setIdentity();
            emitter.translation.set((Tuple3f)this.cachedTranslation);
            Vector3f ax = new Vector3f(parent.m00, parent.m01, parent.m02);
            Vector3f ay = new Vector3f(parent.m10, parent.m11, parent.m12);
            Vector3f az = new Vector3f(parent.m20, parent.m21, parent.m22);
            ax.normalize();
            ay.normalize();
            az.normalize();
            emitter.rotation.setRow(0, ax);
            emitter.rotation.setRow(1, ay);
            emitter.rotation.setRow(2, az);
            Matrix3d rotation = new Matrix3d(emitter.rotation);
            Matrix3d rotscale = new Matrix3d((double)parent.m00, (double)parent.m01, (double)parent.m02, (double)parent.m10, (double)parent.m11, (double)parent.m12, (double)parent.m20, (double)parent.m21, (double)parent.m22);
            try {
                rotation.invert();
                rotscale.mul(rotation);
                emitter.scale[0] = rotscale.m00;
                emitter.scale[1] = rotscale.m11;
                emitter.scale[2] = rotscale.m22;
            }
            catch (SingularMatrixException e) {
                emitter.scale[0] = 0.0;
                emitter.scale[1] = 0.0;
                emitter.scale[2] = 0.0;
            }
            Iterator<BedrockEmitter> it = this.getLastEmitters().iterator();
            while (it.hasNext()) {
                BedrockEmitter last = it.next();
                if (!last.added) {
                    it.remove();
                    continue;
                }
                last.lastGlobal.set((Tuple3d)emitter.lastGlobal);
                last.rotation.set(emitter.rotation);
            }
        } else {
            emitter.lastGlobal.x = Interpolations.lerp((double)target.field_70169_q, (double)target.field_70165_t, (double)partialTicks);
            emitter.lastGlobal.y = Interpolations.lerp((double)target.field_70167_r, (double)target.field_70163_u, (double)partialTicks);
            emitter.lastGlobal.z = Interpolations.lerp((double)target.field_70166_s, (double)target.field_70161_v, (double)partialTicks);
            emitter.rotation.setIdentity();
            Iterator<BedrockEmitter> it = this.getLastEmitters().iterator();
            while (it.hasNext()) {
                BedrockEmitter last = it.next();
                if (!last.added) {
                    it.remove();
                    continue;
                }
                last.lastGlobal.set((Tuple3d)emitter.lastGlobal);
                last.rotation.set(emitter.rotation);
            }
        }
        RenderingHandler.addEmitter(emitter, target);
    }

    public void update(EntityLivingBase target) {
        super.update(target);
        if (target.field_70170_p.field_72995_K) {
            this.updateClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClient() {
        this.getEmitter().sanityTicks = 0;
        for (BedrockEmitter emitter : this.getLastEmitters()) {
            emitter.sanityTicks = 0;
        }
    }

    public AbstractMorph create() {
        return new SnowstormMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof SnowstormMorph) {
            SnowstormMorph morph = (SnowstormMorph)from;
            this.setScheme(morph.scheme);
            this.variables.putAll(morph.variables);
        }
    }

    public float getWidth(EntityLivingBase entityLivingBase) {
        return 0.6f;
    }

    public float getHeight(EntityLivingBase entityLivingBase) {
        return 1.8f;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof SnowstormMorph) {
            SnowstormMorph morph = (SnowstormMorph)((Object)obj);
            result = result && Objects.equals(this.scheme, morph.scheme);
            result = result && Objects.equals(this.variables, morph.variables);
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof SnowstormMorph) {
            SnowstormMorph snow = (SnowstormMorph)morph;
            this.mergeBasic(morph);
            if (!this.scheme.equals(snow.scheme) && this.emitter != null) {
                this.setScheme(snow.scheme);
            }
            return true;
        }
        return super.canMerge(morph);
    }

    public void reset() {
        super.reset();
        this.scheme = "";
        this.variables.clear();
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Vars")) {
            NBTTagCompound vars = tag.func_74775_l("Vars");
            for (String key : vars.func_150296_c()) {
                this.variables.put(key, vars.func_74779_i(key));
            }
        }
        if (tag.func_74764_b("Scheme")) {
            this.setScheme(tag.func_74779_i("Scheme"));
        }
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (!this.variables.isEmpty()) {
            NBTTagCompound vars = new NBTTagCompound();
            for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                vars.func_74778_a(entry.getKey(), entry.getValue());
            }
            tag.func_74782_a("Vars", (NBTBase)vars);
        }
        tag.func_74778_a("Scheme", this.scheme);
    }
}

