/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.structure.PacketStructure;
import mchorse.blockbuster.network.common.structure.PacketStructureRequest;
import mchorse.blockbuster.network.server.ServerHandlerStructureRequest;
import mchorse.blockbuster_pack.morphs.structure.StructureAnimation;
import mchorse.blockbuster_pack.morphs.structure.StructureRenderer;
import mchorse.blockbuster_pack.morphs.structure.StructureStatus;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class StructureMorph
extends AbstractMorph
implements IAnimationProvider,
ISyncableMorph {
    private static final ResourceLocation DEFAULT_BIOME = new ResourceLocation("ocean");
    @SideOnly(value=Side.CLIENT)
    public static Map<String, StructureRenderer> STRUCTURES;
    public static final Map<String, Long> STRUCTURE_CACHE;
    public String structure = "";
    public ResourceLocation biome = DEFAULT_BIOME;
    public boolean lighting = true;
    public ModelTransform pose = new ModelTransform();
    public StructureAnimation animation = new StructureAnimation();
    public float anchorX;
    public float anchorY;
    public float anchorZ;

    @SideOnly(value=Side.CLIENT)
    public static void request() {
        if (STRUCTURES.isEmpty()) {
            Dispatcher.sendToServer(new PacketStructureRequest());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void reloadStructures() {
        StructureMorph.cleanUp();
        StructureMorph.request();
    }

    public static void checkStructures() {
        for (String name : ServerHandlerStructureRequest.getAllStructures()) {
            File file = ServerHandlerStructureRequest.getStructureFolder(name);
            Long modified = STRUCTURE_CACHE.get(name);
            if (modified == null) {
                modified = file.lastModified();
                STRUCTURE_CACHE.put(name, modified);
            }
            if (modified >= file.lastModified()) continue;
            STRUCTURE_CACHE.put(name, file.lastModified());
            PacketStructure packet = new PacketStructure(name, null);
            PlayerList players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            for (String username : players.func_72369_d()) {
                EntityPlayerMP player = players.func_152612_a(username);
                if (player == null) continue;
                Dispatcher.sendTo(packet, player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void cleanUp() {
        for (StructureRenderer renderer : STRUCTURES.values()) {
            renderer.delete();
        }
        STRUCTURES.clear();
    }

    public StructureMorph() {
        this.name = "structure";
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Biome getBiome() {
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)this.biome);
        return biome == null ? Biomes.field_180279_ad : biome;
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        if (previous instanceof StructureMorph) {
            StructureMorph structure = (StructureMorph)previous;
            this.animation.last = new ModelTransform();
            this.animation.last.copy(structure.pose);
        }
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        String suffix = this.structure != null && !this.structure.isEmpty() ? " (" + this.structure + "-" + this.biome.func_110623_a() + ")" : "";
        return I18n.func_135052_a((String)"blockbuster.morph.structure", (Object[])new Object[0]) + suffix;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        StructureRenderer renderer = STRUCTURES.get(this.structure);
        if (renderer != null) {
            if (renderer.status != StructureStatus.LOADED) {
                if (renderer.status == StructureStatus.UNLOADED) {
                    renderer.status = StructureStatus.LOADING;
                    Dispatcher.sendToServer(new PacketStructureRequest(this.structure));
                }
                return;
            }
            int max = Math.max(renderer.size.func_177958_n(), Math.max(renderer.size.func_177956_o(), renderer.size.func_177952_p()));
            scale /= 0.65f * (float)max;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            float lastX = OpenGlHelper.lastBrightnessX;
            float lastY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179129_p();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)45.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.render(this);
            renderer.renderTEs(this);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179118_c();
            GlStateManager.func_179097_i();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastX, (float)lastY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        StructureRenderer renderer = STRUCTURES.get(this.structure);
        if (renderer != null) {
            if (renderer.status != StructureStatus.LOADED) {
                if (renderer.status == StructureStatus.UNLOADED) {
                    renderer.status = StructureStatus.LOADING;
                    Dispatcher.sendToServer(new PacketStructureRequest(this.structure));
                }
                return;
            }
            float lastX = OpenGlHelper.lastBrightnessX;
            float lastY = OpenGlHelper.lastBrightnessY;
            if (GuiModelRenderer.isRendering() && !this.lighting) {
                Minecraft.func_71410_x().field_71460_t.func_180436_i();
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            ModelTransform transform = this.pose;
            float anchorX = this.anchorX;
            float anchorY = this.anchorY;
            float anchorZ = this.anchorZ;
            if (this.animation.isInProgress()) {
                transform = new ModelTransform();
                transform.copy(this.pose);
                this.animation.apply(transform, partialTicks);
                if (this.animation.lastAnchorX != null) {
                    float factor = this.animation.getFactor(partialTicks);
                    anchorX = this.animation.interp.interpolate(this.animation.lastAnchorX.floatValue(), anchorX, factor);
                    anchorY = this.animation.interp.interpolate(this.animation.lastAnchorY.floatValue(), anchorY, factor);
                    anchorZ = this.animation.interp.interpolate(this.animation.lastAnchorZ.floatValue(), anchorZ, factor);
                }
            }
            transform.transform();
            GlStateManager.func_179109_b((float)anchorX, (float)anchorY, (float)anchorZ);
            RenderHelper.func_74518_a();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            renderer.render(this);
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179145_e();
            GlStateManager.func_179085_a((int)0);
            GlStateManager.func_179085_a((int)1);
            GlStateManager.func_179142_g();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            renderer.renderTEs(this);
            GlStateManager.func_179121_F();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastX, (float)lastY);
            if (GuiModelRenderer.isRendering() && !this.lighting) {
                Minecraft.func_71410_x().field_71460_t.func_175072_h();
            }
        }
    }

    public void update(EntityLivingBase target) {
        super.update(target);
        this.animation.update();
    }

    public AbstractMorph create() {
        return new StructureMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof StructureMorph) {
            StructureMorph morph = (StructureMorph)from;
            this.structure = morph.structure;
            this.pose.copy(morph.pose);
            this.animation.copy(morph.animation);
            this.biome = morph.biome;
            this.lighting = morph.lighting;
            this.anchorX = morph.anchorX;
            this.anchorY = morph.anchorY;
            this.anchorZ = morph.anchorZ;
        }
    }

    public float getWidth(EntityLivingBase target) {
        return 0.6f;
    }

    public float getHeight(EntityLivingBase target) {
        return 1.8f;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof StructureMorph) {
            StructureMorph morph = (StructureMorph)((Object)obj);
            result = result && Objects.equals(this.structure, morph.structure);
            result = result && Objects.equals(this.pose, morph.pose);
            result = result && Objects.equals((Object)this.animation, (Object)morph.animation);
            result = result && Objects.equals(this.biome, morph.biome);
            result = result && this.lighting == morph.lighting;
            result = result && this.anchorX == morph.anchorX;
            result = result && this.anchorY == morph.anchorY;
            result = result && this.anchorZ == morph.anchorZ;
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof StructureMorph) {
            StructureMorph structure = (StructureMorph)morph;
            this.mergeBasic(morph);
            if (!structure.animation.ignored) {
                this.animation.merge(this, structure);
                this.copy(structure);
                this.animation.progress = 0;
            }
            return true;
        }
        return super.canMerge(morph);
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Structure")) {
            this.structure = tag.func_74779_i("Structure");
        }
        if (tag.func_74764_b("Pose")) {
            this.pose.fromNBT(tag.func_74775_l("Pose"));
        }
        if (tag.func_74764_b("Animation")) {
            this.animation.fromNBT(tag.func_74775_l("Animation"));
        }
        if (tag.func_74764_b("Biome")) {
            this.biome = new ResourceLocation(tag.func_74779_i("Biome"));
        }
        if (tag.func_74764_b("Lighting")) {
            this.lighting = tag.func_74767_n("Lighting");
        }
        if (tag.func_74764_b("AnchorX")) {
            this.anchorX = tag.func_74760_g("AnchorX");
        }
        if (tag.func_74764_b("AnchorY")) {
            this.anchorY = tag.func_74760_g("AnchorY");
        }
        if (tag.func_74764_b("AnchorZ")) {
            this.anchorZ = tag.func_74760_g("AnchorZ");
        }
    }

    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound animation;
        super.toNBT(tag);
        if (!this.structure.isEmpty()) {
            tag.func_74778_a("Structure", this.structure);
        }
        if (!this.pose.isDefault()) {
            tag.func_74782_a("Pose", (NBTBase)this.pose.toNBT());
        }
        if (!(animation = this.animation.toNBT()).func_82582_d()) {
            tag.func_74782_a("Animation", (NBTBase)animation);
        }
        if (!this.biome.equals((Object)DEFAULT_BIOME)) {
            ResourceLocation biome = this.biome == null ? DEFAULT_BIOME : this.biome;
            tag.func_74778_a("Biome", biome.toString());
        }
        if (!this.lighting) {
            tag.func_74757_a("Lighting", this.lighting);
        }
        if (this.anchorX != 0.0f) {
            tag.func_74776_a("AnchorX", this.anchorX);
        }
        if (this.anchorY != 0.0f) {
            tag.func_74776_a("AnchorY", this.anchorY);
        }
        if (this.anchorZ != 0.0f) {
            tag.func_74776_a("AnchorZ", this.anchorZ);
        }
    }

    static {
        STRUCTURE_CACHE = new HashMap<String, Long>();
    }
}

