/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.animation;

import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public class ActionConfig {
    public String name = "";
    public boolean clamp = true;
    public boolean reset = true;
    public float speed = 1.0f;
    public float fade = 5.0f;
    public int tick = 0;

    public ActionConfig() {
    }

    public ActionConfig(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActionConfig) {
            ActionConfig config = (ActionConfig)obj;
            return Objects.equals(this.name, config.name) && this.clamp == config.clamp && this.reset == config.reset && this.speed == config.speed && this.fade == config.fade && this.tick == config.tick;
        }
        return super.equals(obj);
    }

    public ActionConfig clone() {
        ActionConfig config = new ActionConfig(this.name);
        config.clamp = this.clamp;
        config.reset = this.reset;
        config.speed = this.speed;
        config.fade = this.fade;
        config.tick = this.tick;
        return config;
    }

    public void fromNBT(NBTBase base) {
        if (base instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)base;
            if (tag.func_150297_b("Name", 8)) {
                this.name = tag.func_74779_i("Name");
            }
            if (tag.func_150297_b("Clamp", 99)) {
                this.clamp = tag.func_74767_n("Clamp");
            }
            if (tag.func_150297_b("Reset", 99)) {
                this.reset = tag.func_74767_n("Reset");
            }
            if (tag.func_150297_b("Speed", 99)) {
                this.speed = tag.func_74760_g("Speed");
            }
            if (tag.func_150297_b("Fade", 99)) {
                this.fade = tag.func_74762_e("Fade");
            }
            if (tag.func_150297_b("Tick", 99)) {
                this.tick = tag.func_74762_e("Tick");
            }
        } else if (base instanceof NBTTagString) {
            this.name = ((NBTTagString)base).func_150285_a_();
        }
    }

    public NBTBase toNBT() {
        if (!this.name.isEmpty() && this.isDefault()) {
            return new NBTTagString(this.name);
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.name.isEmpty()) {
            tag.func_74778_a("Name", this.name);
        }
        if (!this.clamp) {
            tag.func_74757_a("Clamp", this.clamp);
        }
        if (!this.reset) {
            tag.func_74757_a("Reset", this.reset);
        }
        if (this.speed != 1.0f) {
            tag.func_74776_a("Speed", this.speed);
        }
        if (this.fade != 5.0f) {
            tag.func_74768_a("Fade", (int)this.fade);
        }
        if (this.tick != 0) {
            tag.func_74768_a("Tick", this.tick);
        }
        return tag;
    }

    public boolean isDefault() {
        return this.clamp && this.reset && this.speed == 1.0f && this.fade == 5.0f && this.tick == 0;
    }
}

