/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.animation;

import mchorse.chameleon.animation.ActionConfig;
import mchorse.chameleon.lib.ChameleonAnimator;
import mchorse.chameleon.lib.data.animation.Animation;
import mchorse.chameleon.lib.data.model.Model;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ActionPlayback {
    public Animation action;
    public ActionConfig config;
    private int fade;
    private float ticks;
    private int duration;
    private double speed = 1.0;
    private boolean looping;
    private Fade fading = Fade.FINISHED;
    public boolean playing = true;
    public int priority;

    public ActionPlayback(Animation action, ActionConfig config) {
        this(action, config, true);
    }

    public ActionPlayback(Animation action, ActionConfig config, boolean looping) {
        this.action = action;
        this.config = config;
        this.duration = action.getLengthInTicks();
        this.looping = looping;
        this.setSpeed(1.0);
    }

    public ActionPlayback(Animation action, ActionConfig config, boolean looping, int priority) {
        this(action, config, looping);
        this.priority = priority;
    }

    public void reset() {
        if (this.config.reset) {
            this.ticks = Math.copySign(1.0, this.speed) < 0.0 ? (float)this.duration : 0.0f;
        }
        this.stopFade();
    }

    public boolean finishedFading() {
        return this.fading != Fade.FINISHED && this.fade <= 0;
    }

    public boolean isFadingModeOut() {
        return this.fading == Fade.OUT;
    }

    public boolean isFadingModeIn() {
        return this.fading == Fade.IN;
    }

    public boolean isFading() {
        return this.fading != Fade.FINISHED && this.fade > 0;
    }

    public void fadeOut() {
        this.fade = (int)this.config.fade;
        this.fading = Fade.OUT;
    }

    public void fadeIn() {
        this.fade = (int)this.config.fade;
        this.fading = Fade.IN;
    }

    public void stopFade() {
        this.fade = 0;
        this.fading = Fade.FINISHED;
    }

    public int getFade() {
        return this.fade;
    }

    public float getFadeFactor(float partialTicks) {
        float factor = ((float)this.fade - partialTicks) / this.config.fade;
        return this.fading == Fade.OUT ? factor : 1.0f - factor;
    }

    public void setSpeed(double speed) {
        this.speed = speed * (double)this.config.speed;
    }

    public void update() {
        if (this.fading != Fade.FINISHED && this.fade > 0) {
            --this.fade;
        }
        if (!this.playing) {
            return;
        }
        this.ticks = (float)((double)this.ticks + this.speed);
        if (!this.looping && this.fading != Fade.OUT && this.ticks >= (float)this.duration) {
            this.fadeOut();
        }
        if (this.looping) {
            if (this.ticks >= (float)this.duration && this.speed > 0.0 && this.config.clamp) {
                this.ticks -= (float)this.duration;
                this.ticks += (float)this.config.tick;
            } else if (this.ticks < 0.0f && this.speed < 0.0 && this.config.clamp) {
                this.ticks = (float)this.duration + this.ticks;
                this.ticks -= (float)this.config.tick;
            }
        }
    }

    public float getTick(float partialTick) {
        float ticks = this.ticks + (float)((double)partialTick * this.speed);
        if (this.looping) {
            if (ticks >= (float)this.duration && this.speed > 0.0 && this.config.clamp) {
                ticks -= (float)this.duration;
            } else if (this.ticks < 0.0f && this.speed < 0.0 && this.config.clamp) {
                ticks = (float)this.duration + ticks;
            }
        }
        return ticks;
    }

    public void apply(EntityLivingBase target, Model armature, float partialTick, float blend, boolean skipInitial) {
        ChameleonAnimator.animate(target, armature, this.action, this.getTick(partialTick), blend, skipInitial);
    }

    public static enum Fade {
        OUT,
        FINISHED,
        IN;

    }
}

