/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph;

import java.util.HashMap;
import mchorse.chameleon.Chameleon;
import mchorse.chameleon.ClientProxy;
import mchorse.chameleon.metamorph.ChameleonMorph;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.metamorph.api.creative.categories.MorphCategory;
import mchorse.metamorph.api.creative.sections.MorphSection;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChameleonSection
extends MorphSection {
    public ChameleonSection(String title) {
        super(title);
    }

    public void update(World world) {
        Chameleon.proxy.reloadModels();
        this.categories.clear();
        HashMap<String, ChameleonCategory> categories = new HashMap<String, ChameleonCategory>();
        for (String key : Chameleon.proxy.getModelKeys()) {
            ChameleonMorph morph = new ChameleonMorph();
            FolderEntry skins = ClientProxy.tree.getByPath(key + "/skins/", null);
            if (skins != null) {
                for (AbstractEntry entry : skins.getEntries()) {
                    if (!(entry instanceof FileEntry)) continue;
                    morph.skin = ((FileEntry)entry).resource;
                    break;
                }
            }
            morph.name = "chameleon." + key;
            String categoryKey = key.contains("/") ? key.substring(0, key.lastIndexOf("/")) : "";
            ChameleonCategory category = (ChameleonCategory)((Object)categories.get(categoryKey));
            if (category == null) {
                category = new ChameleonCategory(this, "chameleon", categoryKey);
                categories.put(categoryKey, category);
            }
            category.add(morph);
        }
        for (ChameleonCategory category : categories.values()) {
            category.sort();
            this.categories.add(category);
        }
        this.categories.sort((a, b) -> a.getTitle().compareTo(b.getTitle()));
    }

    public static class ChameleonCategory
    extends MorphCategory {
        private String subtitle;

        public ChameleonCategory(MorphSection parent, String title, String subtitle) {
            super(parent, title);
            this.subtitle = subtitle;
        }

        @SideOnly(value=Side.CLIENT)
        public String getTitle() {
            return super.getTitle() + (this.subtitle == null || this.subtitle.isEmpty() ? "" : " (" + this.subtitle + ")");
        }
    }
}

