/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.editor;

import mchorse.chameleon.animation.ActionConfig;
import mchorse.chameleon.lib.data.animation.Animation;
import mchorse.chameleon.metamorph.ChameleonMorph;
import mchorse.chameleon.metamorph.editor.GuiChameleonMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringSearchListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiActionsPanel
extends GuiMorphPanel<ChameleonMorph, GuiChameleonMorph> {
    public static final String[] ACTIONS = new String[]{"Idle", "Running", "Sprinting", "Crouching", "CrouchingIdle", "Swimming", "SwimmingIdle", "Flying", "FlyingIdle", "Riding", "RidingIdle", "Dying", "Falling", "Sleeping", "Jump", "Swipe", "Hurt", "Land", "Shoot", "Consume"};
    public ActionConfig config;
    public GuiStringListElement configs;
    public GuiElement fields;
    public GuiStringSearchListElement action;
    public GuiToggleElement clamp;
    public GuiToggleElement reset;
    public GuiTrackpadElement speed;
    public GuiTrackpadElement fade;
    public GuiTrackpadElement tick;
    private IKey actionsTitle = IKey.lang((String)"chameleon.gui.editor.actions.actions");
    private IKey actionTitle = IKey.lang((String)"chameleon.gui.editor.actions.action");

    public GuiActionsPanel(Minecraft mc, GuiChameleonMorph editor) {
        super(mc, (GuiAbstractMorph)editor);
        this.configs = new GuiStringListElement(mc, str -> this.selectAction((String)str.get(0)));
        for (String action : ACTIONS) {
            this.configs.add((Object)action);
        }
        this.fields = new GuiElement(mc).noCulling();
        this.configs.sort();
        this.configs.flex().relative((GuiElement)this).set(10.0f, 22.0f, 110.0f, 90.0f).h(1.0f, -35);
        this.action = new GuiStringSearchListElement(mc, value -> {
            this.config.name = (String)value.get(0);
        });
        this.clamp = new GuiToggleElement(mc, IKey.lang((String)"chameleon.gui.editor.actions.clamp"), false, b -> {
            this.config.clamp = b.isToggled();
        });
        this.reset = new GuiToggleElement(mc, IKey.lang((String)"chameleon.gui.editor.actions.reset"), false, b -> {
            this.config.reset = b.isToggled();
        });
        this.speed = new GuiTrackpadElement(mc, value -> {
            this.config.speed = value.floatValue();
        });
        this.speed.tooltip(IKey.lang((String)"chameleon.gui.editor.actions.speed"));
        this.fade = new GuiTrackpadElement(mc, value -> {
            this.config.fade = value.intValue();
        });
        this.fade.tooltip(IKey.lang((String)"chameleon.gui.editor.actions.fade"));
        this.fade.limit(0.0, 2.147483647E9, true);
        this.tick = new GuiTrackpadElement(mc, value -> {
            this.config.tick = value.intValue();
        });
        this.tick.tooltip(IKey.lang((String)"chameleon.gui.editor.actions.tick"));
        this.tick.limit(0.0, 2.147483647E9, true);
        GuiElement fields = new GuiElement(mc);
        fields.flex().relative((GuiElement)this).xy(1.0f, 1.0f).w(130).anchor(1.0f, 1.0f).column(5).vertical().stretch().padding(10);
        fields.add(new IGuiElement[]{this.clamp, this.reset, this.speed, this.fade, this.tick});
        this.action.flex().relative((IResizer)this.area).x(1.0f, -10).y(22).w(110).hTo((IResizer)fields.area, 5).anchorX(1.0f);
        this.fields.add(new IGuiElement[]{fields, this.action});
        this.fields.setVisible(false);
        this.add(new IGuiElement[]{this.configs, this.fields});
    }

    private void selectAction(String name) {
        ActionConfig config = ((ChameleonMorph)this.morph).actions.actions.get(name = ((ChameleonMorph)this.morph).actions.toKey(name));
        if (config == null) {
            config = ((ChameleonMorph)this.morph).actions.actions.get(name);
            config = config == null ? new ActionConfig(name) : config.clone();
            ((ChameleonMorph)this.morph).actions.actions.put(name, config);
        }
        this.config = config;
        this.fields.setVisible(true);
        this.fillFields(config);
    }

    public void fillData(ChameleonMorph morph) {
        super.fillData((AbstractMorph)morph);
        this.action.list.clear();
        for (Animation animation : morph.getModel().animations.getAll()) {
            this.action.list.add((Object)animation.id);
        }
        this.action.list.sort();
        this.action.list.setCurrent((Object)"");
        this.fields.setVisible(false);
        this.configs.setCurrent((Object)"");
    }

    private void fillFields(ActionConfig config) {
        this.action.list.setCurrentScroll((Object)config.name);
        this.clamp.toggled(config.clamp);
        this.reset.toggled(config.reset);
        this.speed.setValue((double)config.speed);
        this.fade.setValue((double)((int)config.fade));
        this.tick.setValue((double)config.tick);
    }

    public void draw(GuiContext context) {
        this.configs.area.draw(-2013265920);
        this.font.func_175063_a(this.actionsTitle.get(), (float)this.configs.area.x, (float)(this.configs.area.y - 12), 0xFFFFFF);
        if (this.fields.isVisible()) {
            this.font.func_175063_a(this.actionTitle.get(), (float)this.action.area.x, (float)(this.action.area.y - 12), 0xFFFFFF);
            this.action.area.draw(-2013265920);
        }
        super.draw(context);
    }
}

