/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.editor;

import java.util.List;
import java.util.function.Consumer;
import mchorse.chameleon.lib.ChameleonModel;
import mchorse.chameleon.metamorph.ChameleonMorph;
import mchorse.chameleon.metamorph.editor.GuiChameleonMorph;
import mchorse.chameleon.metamorph.editor.IBonePicker;
import mchorse.chameleon.metamorph.pose.AnimatedPose;
import mchorse.chameleon.metamorph.pose.AnimatedPoseTransform;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAnimation;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GuiChameleonMainPanel
extends GuiMorphPanel<ChameleonMorph, GuiChameleonMorph>
implements IBonePicker {
    public GuiButtonElement skin;
    public GuiTexturePicker picker;
    public GuiButtonElement createPose;
    public GuiStringListElement bones;
    public GuiToggleElement fixed;
    public GuiToggleElement animated;
    public GuiPoseTransformations transforms;
    public GuiAnimation animation;
    public GuiTrackpadElement scale;
    public GuiTrackpadElement scaleGui;
    private IKey createLabel = IKey.lang((String)"chameleon.gui.editor.create_pose");
    private IKey resetLabel = IKey.lang((String)"chameleon.gui.editor.reset_pose");
    private AnimatedPoseTransform transform;

    public static GuiContextMenu createCopyPasteMenu(Runnable copy, Consumer<AnimatedPose> paste) {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(Minecraft.func_71410_x());
        AnimatedPose pose = null;
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
            AnimatedPose loaded = new AnimatedPose();
            loaded.fromNBT(tag);
            pose = loaded;
        }
        catch (Exception tag) {
            // empty catch block
        }
        menu.action(Icons.COPY, IKey.lang((String)"chameleon.gui.editor.context.copy"), copy);
        if (pose != null) {
            AnimatedPose innerPose = pose;
            menu.action(Icons.PASTE, IKey.lang((String)"chameleon.gui.editor.context.paste"), () -> paste.accept(innerPose));
        }
        return menu;
    }

    public GuiChameleonMainPanel(Minecraft mc, GuiChameleonMorph editor) {
        super(mc, (GuiAbstractMorph)editor);
        this.skin = new GuiButtonElement(mc, IKey.lang((String)"chameleon.gui.editor.pick_skin"), b -> {
            this.picker.refresh();
            this.picker.fill(((ChameleonMorph)this.morph).skin);
            this.add((IGuiElement)this.picker);
            this.picker.resize();
        });
        this.picker = new GuiTexturePicker(mc, rl -> {
            ((ChameleonMorph)this.morph).skin = RLUtils.clone((ResourceLocation)rl);
        });
        this.createPose = new GuiButtonElement(mc, this.createLabel, this::createResetPose);
        this.bones = new GuiStringListElement(mc, this::pickBone);
        this.bones.background().context(() -> GuiChameleonMainPanel.createCopyPasteMenu(this::copyCurrentPose, this::pastePose));
        this.fixed = new GuiToggleElement(mc, IKey.lang((String)"chameleon.gui.editor.fixed"), this::toggleFixed);
        this.animated = new GuiToggleElement(mc, IKey.lang((String)"chameleon.gui.editor.animated"), this::toggleAnimated);
        this.transforms = new GuiPoseTransformations(mc);
        this.animation = new GuiAnimation(mc, false);
        this.scale = new GuiTrackpadElement(mc, value -> {
            ((ChameleonMorph)this.morph).scale = value.floatValue();
        });
        this.scale.tooltip(IKey.lang((String)"chameleon.gui.editor.scale"));
        this.scaleGui = new GuiTrackpadElement(mc, value -> {
            ((ChameleonMorph)this.morph).scaleGui = value.floatValue();
        });
        this.scaleGui.tooltip(IKey.lang((String)"chameleon.gui.editor.scale_gui"));
        this.skin.flex().relative((GuiElement)this).set(10.0f, 10.0f, 110.0f, 20.0f);
        this.picker.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.createPose.flex().relative((GuiElement)this.skin).y(1.0f, 5).w(1.0f).h(20);
        this.bones.flex().relative((GuiElement)this.createPose).y(1.0f, 5).w(1.0f).hTo((IResizer)this.fixed.flex(), -5);
        this.animated.flex().relative((GuiElement)this).x(10).y(1.0f, -10).w(110).anchorY(1.0f);
        this.fixed.flex().relative((GuiElement)this.animated).y(-1.0f, -5).w(1.0f);
        this.transforms.flex().relative((GuiElement)this).set(0.0f, 0.0f, 190.0f, 70.0f).x(0.5f, -95).y(1.0f, -80);
        this.animation.flex().relative((GuiElement)this).x(1.0f, -130).w(130);
        GuiElement lowerBottom = new GuiElement(mc);
        lowerBottom.flex().relative((GuiElement)this).xy(1.0f, 1.0f).w(130).anchor(1.0f, 1.0f).column(5).vertical().stretch().padding(10);
        lowerBottom.add(new IGuiElement[]{this.scale, this.scaleGui});
        this.add(new IGuiElement[]{this.skin, this.createPose, this.animated, this.fixed, this.bones, this.transforms, this.animation, lowerBottom});
    }

    private void copyCurrentPose() {
        GuiScreen.func_146275_d((String)((ChameleonMorph)this.morph).pose.toNBT().toString());
    }

    private void pastePose(AnimatedPose pose) {
        ((ChameleonMorph)this.morph).pose.copy(pose);
        this.transforms.set(this.transforms.trans);
    }

    private void createResetPose(GuiButtonElement button) {
        if (((ChameleonMorph)this.morph).pose == null) {
            AnimatedPose pose = new AnimatedPose();
            List<String> bones = ((ChameleonMorph)this.morph).getModel().getBoneNames();
            for (String bone : bones) {
                pose.bones.put(bone, new AnimatedPoseTransform(bone));
            }
            ((ChameleonMorph)this.morph).pose = pose;
        } else {
            ((ChameleonMorph)this.morph).pose = null;
            ((GuiChameleonMorph)this.editor).chameleonModelRenderer.boneName = "";
        }
        this.setPoseEditorVisible();
    }

    private void pickBone(List<String> bone) {
        this.pickBone(bone.get(0));
    }

    @Override
    public void pickBone(String bone) {
        if (((ChameleonMorph)this.morph).pose == null) {
            return;
        }
        this.transform = ((ChameleonMorph)this.morph).pose.bones.get(bone);
        this.bones.setCurrentScroll((Object)bone);
        this.animated.toggled(((ChameleonMorph)this.morph).pose.animated == 1.0f);
        this.fixed.toggled(this.transform.fixed == 0.0f);
        this.transforms.set(this.transform);
        ((GuiChameleonMorph)this.editor).chameleonModelRenderer.boneName = bone;
    }

    private void toggleFixed(GuiToggleElement toggle) {
        this.transform.fixed = toggle.isToggled() ? 0.0f : 1.0f;
    }

    private void toggleAnimated(GuiToggleElement toggle) {
        ((ChameleonMorph)this.morph).pose.animated = toggle.isToggled() ? 1.0f : 0.0f;
    }

    public void fillData(ChameleonMorph morph) {
        super.fillData((AbstractMorph)morph);
        this.picker.removeFromParent();
        this.setPoseEditorVisible();
        this.animation.fill((Animation)morph.animation);
        this.scale.setValue((double)morph.scale);
        this.scaleGui.setValue((double)morph.scaleGui);
    }

    public void finishEditing() {
        this.picker.close();
    }

    private void setPoseEditorVisible() {
        ChameleonModel model = ((ChameleonMorph)this.morph).getModel();
        AnimatedPose pose = ((ChameleonMorph)this.morph).pose;
        this.createPose.setVisible(model != null && !model.getBoneNames().isEmpty());
        this.createPose.label = pose == null ? this.createLabel : this.resetLabel;
        this.bones.setVisible(model != null && pose != null);
        this.fixed.setVisible(model != null && pose != null);
        this.animated.setVisible(model != null && pose != null);
        this.transforms.setVisible(model != null && pose != null);
        if (model != null) {
            this.bones.clear();
            this.bones.add(model.getBoneNames());
            this.bones.sort();
            if (((ChameleonMorph)this.morph).pose != null) {
                this.pickBone(model.getBoneNames().get(0));
            }
        }
    }

    public static class GuiPoseTransformations
    extends GuiTransformations {
        public AnimatedPoseTransform trans;

        public GuiPoseTransformations(Minecraft mc) {
            super(mc);
        }

        public void set(AnimatedPoseTransform trans) {
            this.trans = trans;
            if (trans != null) {
                this.fillT(trans.x, trans.y, trans.z);
                this.fillS(trans.scaleX, trans.scaleY, trans.scaleZ);
                this.fillR(trans.rotateX / (float)Math.PI * 180.0f, trans.rotateY / (float)Math.PI * 180.0f, trans.rotateZ / (float)Math.PI * 180.0f);
            }
        }

        public void setT(double x, double y, double z) {
            this.trans.x = (float)x;
            this.trans.y = (float)y;
            this.trans.z = (float)z;
        }

        public void setS(double x, double y, double z) {
            this.trans.scaleX = (float)x;
            this.trans.scaleY = (float)y;
            this.trans.scaleZ = (float)z;
        }

        public void setR(double x, double y, double z) {
            this.trans.rotateX = (float)(x / 180.0 * 3.1415927410125732);
            this.trans.rotateY = (float)(y / 180.0 * 3.1415927410125732);
            this.trans.rotateZ = (float)(z / 180.0 * 3.1415927410125732);
        }
    }
}

