/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registry;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.ModCreativeTab;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRegistry {
    public static final String unlocalizedPrefix = "mod.chiselsandbits.";
    static ModCreativeTab creativeTab = new ModCreativeTab();
    static CreativeClipboardTab creativeClipboard = null;
    List<Item> registeredItems = new ArrayList<Item>();
    List<Block> registeredBlocks = new ArrayList<Block>();

    public ModRegistry() {
        ChiselsAndBits.registerWithBus(this);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry r = e.getRegistry();
        for (Item b : this.registeredItems) {
            r.register((IForgeRegistryEntry)b);
        }
        if (!this.registeredItems.isEmpty() && ChiselsAndBits.getInstance().loadClientAssets()) {
            ClientSide.instance.registerItemModels();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry r = e.getRegistry();
        for (Block b : this.registeredBlocks) {
            r.register((IForgeRegistryEntry)b);
        }
        if (!this.registeredBlocks.isEmpty() && ChiselsAndBits.getInstance().loadClientAssets()) {
            ClientSide.instance.registerBlockModels();
        }
    }

    protected <T extends Item> T registerItem(boolean enabled, T item, String name) {
        if (enabled) {
            item.func_77637_a((CreativeTabs)creativeTab);
            item.func_77655_b(unlocalizedPrefix + name);
            item.setRegistryName("chiselsandbits", name);
            this.registeredItems.add(item);
            return item;
        }
        return null;
    }

    protected void registerBlock(Block block, ItemBlock item, String name) {
        block.func_149647_a((CreativeTabs)creativeTab);
        item.setRegistryName("chiselsandbits", name);
        block.setRegistryName("chiselsandbits", name);
        block.func_149663_c(unlocalizedPrefix + name);
        item.func_77655_b(unlocalizedPrefix + name);
        this.registeredBlocks.add(block);
        this.registeredItems.add((Item)item);
    }

    static {
        if (ChiselsAndBits.getConfig().creativeClipboardSize > 0) {
            creativeClipboard = new CreativeClipboardTab();
        }
    }
}

