/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph;

import java.io.File;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphHandler;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.RegisterHandler;
import mchorse.metamorph.capabilities.CapabilityHandler;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.capabilities.morphing.MorphingStorage;
import mchorse.metamorph.capabilities.render.IModelRenderer;
import mchorse.metamorph.capabilities.render.ModelRenderer;
import mchorse.metamorph.capabilities.render.ModelRendererStorage;
import mchorse.metamorph.entity.EntityMorph;
import mchorse.metamorph.entity.SoundHandler;
import mchorse.metamorph.network.Dispatcher;
import mchorse.vanilla_pack.MetamorphFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CommonProxy {
    public File morphs;
    public File blacklist;
    public File remap;
    public File selectors;
    public File list;

    public void preLoad(FMLPreInitializationEvent event) {
        Dispatcher.register();
        MorphManager.INSTANCE.factories.add(new MetamorphFactory());
        this.morphs = new File(event.getModConfigurationDirectory(), "metamorph/morphs.json");
        this.blacklist = new File(event.getModConfigurationDirectory(), "metamorph/blacklist.json");
        this.remap = new File(event.getModConfigurationDirectory(), "metamorph/remap.json");
        this.selectors = new File(event.getModConfigurationDirectory(), "metamorph/selectors.json");
        this.list = new File(event.getModConfigurationDirectory(), "metamorph/list.json");
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("metamorph:morph"), EntityMorph.class, (String)"Morph", (int)0, (Object)Metamorph.instance, (int)64, (int)3, (boolean)false);
    }

    public void load() {
        MinecraftForge.EVENT_BUS.register((Object)new MorphHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SoundHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RegisterHandler());
        CapabilityManager.INSTANCE.register(IMorphing.class, (Capability.IStorage)new MorphingStorage(), Morphing::new);
        CapabilityManager.INSTANCE.register(IModelRenderer.class, (Capability.IStorage)new ModelRendererStorage(), ModelRenderer::new);
        MorphManager.INSTANCE.register();
        if (!this.morphs.exists()) {
            MorphUtils.generateFile(this.morphs, "{}");
        }
        if (!this.blacklist.exists()) {
            MorphUtils.generateFile(this.blacklist, "[]");
        }
        if (!this.remap.exists()) {
            MorphUtils.generateFile(this.remap, "{}");
        }
    }

    public void postLoad(FMLPostInitializationEvent event) {
    }

    public boolean canUse(EntityPlayer player) {
        return player.func_184812_l_() || Metamorph.allowMorphingIntoCategoryMorphs.get();
    }

    public boolean canEditSelectors() {
        return true;
    }
}

