/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BodyPartManager {
    public List<BodyPart> parts = new ArrayList<BodyPart>();
    private boolean initiated;

    public void reset() {
        this.initiated = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void reinitBodyParts() {
        this.reset();
        this.initBodyParts();
    }

    @SideOnly(value=Side.CLIENT)
    public void initBodyParts() {
        if (!this.initiated) {
            for (BodyPart part : this.parts) {
                part.init();
            }
            this.initiated = true;
        }
    }

    public void updateBodyLimbs(AbstractMorph parent, EntityLivingBase target) {
        for (BodyPart part : this.parts) {
            part.update(parent, target);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BodyPartManager) {
            BodyPartManager manager = (BodyPartManager)obj;
            return this.parts.equals(manager.parts);
        }
        return super.equals(obj);
    }

    public void copy(BodyPartManager manager) {
        this.reset();
        this.parts.clear();
        for (BodyPart part : manager.parts) {
            this.parts.add(part.copy());
        }
    }

    public void merge(BodyPartManager manager) {
        this.initiated = false;
        int c = manager.parts.size();
        for (int i = 0; i < c; ++i) {
            BodyPart part = i < this.parts.size() ? this.parts.get(i) : null;
            BodyPart other = manager.parts.get(i);
            if (part == null) {
                this.parts.add(other);
                continue;
            }
            if (part.canMerge(other)) continue;
            this.parts.set(i, other.copy());
        }
        this.ensureCount(manager.parts.size());
    }

    public void afterMerge(BodyPartManager manager) {
        if (manager.parts.size() != this.parts.size()) {
            this.copy(manager);
            return;
        }
        int c = this.parts.size();
        for (int i = 0; i < c; ++i) {
            BodyPart part = this.parts.get(i);
            BodyPart other = manager.parts.get(i);
            if (part.morph.isEmpty() || other.morph.isEmpty()) continue;
            part.morph.get().afterMerge(other.morph.get());
        }
    }

    public void pause(AbstractMorph previous, int offset) {
        BodyPartManager parts = previous instanceof IBodyPartProvider ? ((IBodyPartProvider)((Object)previous)).getBodyPart() : null;
        for (int i = 0; i < this.parts.size(); ++i) {
            BodyPart current = this.parts.get(i);
            BodyPart past = null;
            if (parts != null) {
                past = i < parts.parts.size() ? parts.parts.get(i) : null;
            }
            current.pause(past, offset);
        }
    }

    private void ensureCount(int count) {
        count = Math.max(count, 0);
        while (this.parts.size() > count) {
            this.parts.remove(this.parts.size() - 1);
        }
    }

    public NBTTagList toNBT() {
        if (!this.parts.isEmpty()) {
            NBTTagList bodyParts = new NBTTagList();
            for (BodyPart part : this.parts) {
                NBTTagCompound bodyPart = new NBTTagCompound();
                part.toNBT(bodyPart);
                if (bodyPart.func_82582_d()) continue;
                bodyParts.func_74742_a((NBTBase)bodyPart);
            }
            return bodyParts;
        }
        return null;
    }

    public void fromNBT(NBTTagList bodyParts) {
        this.parts.clear();
        int c = bodyParts.func_74745_c();
        for (int i = 0; i < c; ++i) {
            NBTTagCompound bodyPart = bodyParts.func_150305_b(i);
            BodyPart part = new BodyPart();
            part.fromNBT(bodyPart);
            this.parts.add(part);
        }
    }
}

