/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities;

import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import mchorse.metamorph.capabilities.render.IModelRenderer;
import mchorse.metamorph.capabilities.render.ModelProvider;
import mchorse.metamorph.capabilities.render.ModelRenderer;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.PacketBlacklist;
import mchorse.metamorph.network.common.PacketSettings;
import mchorse.metamorph.network.common.creative.PacketMorph;
import mchorse.metamorph.network.common.survival.PacketAcquiredMorphs;
import mchorse.metamorph.network.common.survival.PacketMorphPlayer;
import mchorse.metamorph.network.common.survival.PacketMorphState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityHandler {
    public static final ResourceLocation MORPHING_CAP = new ResourceLocation("metamorph", "morphing_capability");
    public static final ResourceLocation MODEL_CAP = new ResourceLocation("metamorph", "model");
    private static Boolean isMohist;

    private static boolean isMohist() {
        if (isMohist != null) {
            return isMohist;
        }
        try {
            Class.forName("com.mohistmc.MohistMC");
            isMohist = true;
        }
        catch (Exception e) {
            isMohist = false;
        }
        return isMohist;
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase && ((Entity)event.getObject()).field_70170_p.field_72995_K) {
            event.addCapability(MODEL_CAP, (ICapabilityProvider)new ModelProvider());
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(MORPHING_CAP, (ICapabilityProvider)new MorphingProvider());
        }
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        IMorphing cap = Morphing.get(player);
        if (cap != null) {
            this.sendAcquiredMorphs(cap, player);
            if (cap.isMorphed()) {
                cap.getCurrentMorph().morph((EntityLivingBase)player);
            }
            Dispatcher.sendTo(new PacketBlacklist(MorphManager.INSTANCE.activeBlacklist), (EntityPlayerMP)player);
            Dispatcher.sendTo(new PacketSettings(MorphManager.INSTANCE.activeSettings), (EntityPlayerMP)player);
            Dispatcher.sendTo(new PacketMorphState(player, cap), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void playerStartsTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer) {
            Entity target = event.getTarget();
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            IMorphing cap = (IMorphing)target.getCapability(MorphingProvider.MORPHING_CAP, null);
            Dispatcher.sendTo(new PacketMorphPlayer(target.func_145782_y(), cap.getCurrentMorph()), player);
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entity;
            IMorphing morphing = Morphing.get(player);
            this.sendAcquiredMorphs(morphing, player);
            Dispatcher.sendTo(new PacketMorphState(player, morphing), (EntityPlayerMP)player);
        } else if (entity instanceof EntityLivingBase && entity.field_70170_p.field_72995_K) {
            IModelRenderer renderer = ModelRenderer.get(entity);
            renderer.updateSelector((EntityLivingBase)entity);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IMorphing morphing = Morphing.get(player);
        IMorphing oldMorphing = Morphing.get(event.getOriginal());
        if (!(CapabilityHandler.isMohist() || !Metamorph.keepMorphs.get() && event.isWasDeath())) {
            morphing.copy(oldMorphing, player);
        }
    }

    private void sendAcquiredMorphs(IMorphing cap, EntityPlayer player) {
        EntityPlayerMP mp = (EntityPlayerMP)player;
        Dispatcher.sendTo(new PacketMorph(cap.getCurrentMorph()), mp);
        Dispatcher.sendTo(new PacketAcquiredMorphs(cap.getAcquiredMorphs()), mp);
    }
}

