/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities.morphing;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Morphing
implements IMorphing {
    private List<AbstractMorph> acquiredMorphs = new ArrayList<AbstractMorph>();
    private Morph morph = new Morph();
    private AbstractMorph previousMorph;
    private int animation;
    private DamageSource lastDamageSource;
    private float lastHealthRatio;
    private boolean hasSquidAir = false;
    private int squidAir = 300;
    private float lastHealth;

    public static IMorphing get(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return (IMorphing)player.getCapability(MorphingProvider.MORPHING_CAP, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        if (Metamorph.disableMorphAnimation.get()) {
            return false;
        }
        return this.animation != -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getAnimation() {
        return this.animation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AbstractMorph getPreviousMorph() {
        return this.previousMorph;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderPlayer(EntityPlayer player, double x, double y, double z, float yaw, float partialTick) {
        if (player.func_175149_v()) {
            return false;
        }
        if (this.morph.isEmpty() && !this.isAnimating()) {
            return false;
        }
        if (this.morph.isEmpty() && this.animation <= 10 || this.previousMorph == null && this.animation > 10) {
            return false;
        }
        if (!this.isAnimating() && MorphUtils.render(this.morph.get(), (EntityLivingBase)player, x, y, z, yaw, partialTick)) {
            return true;
        }
        GlStateManager.func_179094_E();
        if (this.animation <= 10) {
            float anim = ((float)this.animation - partialTick) / 10.0f;
            float offset = 0.0f;
            if (anim >= 0.0f) {
                offset = -anim * anim * 2.0f;
            }
            GlStateManager.func_179137_b((double)x, (double)(y + (double)offset), (double)z);
            if (anim >= 0.0f) {
                GlStateManager.func_179114_b((float)(anim * -90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(1.0f - anim), (float)(1.0f - anim), (float)(1.0f - anim));
            }
            MorphUtils.render(this.morph.get(), (EntityLivingBase)player, 0.0, 0.0, 0.0, yaw, partialTick);
        } else if (this.previousMorph != null) {
            float anim = ((float)(this.animation - 10) - partialTick) / 10.0f;
            float offset = 0.0f;
            if (anim >= 0.0f) {
                offset = 1.0f - anim;
            }
            GlStateManager.func_179137_b((double)x, (double)(y + (double)offset), (double)z);
            if (anim >= 0.0f) {
                GlStateManager.func_179114_b((float)((1.0f - anim) * 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)anim, (float)anim, (float)anim);
            }
            MorphUtils.render(this.previousMorph, (EntityLivingBase)player, 0.0, 0.0, 0.0, yaw, partialTick);
        }
        GlStateManager.func_179121_F();
        return true;
    }

    @Override
    public DamageSource getLastDamageSource() {
        return this.lastDamageSource;
    }

    @Override
    public void setLastDamageSource(DamageSource damageSource) {
        this.lastDamageSource = damageSource;
    }

    @Override
    public boolean acquireMorph(AbstractMorph morph) {
        if (morph == null || this.acquiredMorph(morph)) {
            return false;
        }
        this.acquiredMorphs.add(morph);
        return true;
    }

    @Override
    public boolean acquiredMorph(AbstractMorph morph) {
        for (AbstractMorph acquired : this.acquiredMorphs) {
            if (!acquired.equals(morph)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AbstractMorph> getAcquiredMorphs() {
        return this.acquiredMorphs;
    }

    @Override
    public void setAcquiredMorphs(List<AbstractMorph> morphs) {
        this.acquiredMorphs.clear();
        this.acquiredMorphs.addAll(morphs);
    }

    @Override
    public AbstractMorph getCurrentMorph() {
        return this.morph.get();
    }

    @Override
    public boolean setCurrentMorph(AbstractMorph morph, EntityPlayer player, boolean force) {
        boolean creative;
        if (morph == null) {
            this.demorph(player);
            return true;
        }
        boolean bl = creative = player != null && player.func_184812_l_();
        if (force || creative || this.acquiredMorph(morph)) {
            if (player != null) {
                if (this.morph.isEmpty()) {
                    this.lastHealth = (float)player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                } else {
                    this.morph.get().demorph((EntityLivingBase)player);
                }
            }
            this.setMorph(morph);
            if (player != null && !this.morph.isEmpty()) {
                AbstractMorph current = this.morph.get();
                this.setHealth((EntityLivingBase)player, current.settings.health);
                current.morph((EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void demorph(EntityPlayer player) {
        if (player != null && !this.morph.isEmpty()) {
            this.morph.get().demorph((EntityLivingBase)player);
        }
        if (player != null) {
            this.setHealth((EntityLivingBase)player, this.lastHealth <= 0.0f ? 20.0f : this.lastHealth);
        }
        this.setMorph(null);
    }

    protected void setMorph(AbstractMorph morph) {
        AbstractMorph previous = this.morph.get();
        if (this.morph.set(morph)) {
            if (!Metamorph.disableMorphAnimation.get()) {
                this.animation = 20;
            }
            this.previousMorph = previous;
        }
    }

    @Override
    public boolean isMorphed() {
        return !this.morph.isEmpty();
    }

    @Override
    public void favorite(int index) {
        if (index >= 0 && index < this.acquiredMorphs.size()) {
            AbstractMorph morph = this.acquiredMorphs.get(index);
            morph.favorite = !morph.favorite;
        }
    }

    @Override
    public void keybind(int index, int keycode) {
        if (index >= 0 && index < this.acquiredMorphs.size()) {
            AbstractMorph morph = this.acquiredMorphs.get(index);
            morph.keybind = keycode;
        }
    }

    @Override
    public boolean remove(int index) {
        if (index >= 0 && index < this.acquiredMorphs.size()) {
            this.acquiredMorphs.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public void removeAcquired() {
        this.acquiredMorphs.clear();
    }

    @Override
    public void copy(IMorphing morphing, EntityPlayer player) {
        this.acquiredMorphs.addAll(morphing.getAcquiredMorphs());
        if (morphing.getCurrentMorph() != null) {
            this.setCurrentMorph(morphing.getCurrentMorph().copy(), player, true);
        } else {
            this.setCurrentMorph(null, player, true);
        }
    }

    @Override
    public float getLastHealthRatio() {
        return this.lastHealthRatio;
    }

    @Override
    public void setLastHealthRatio(float lastHealthRatio) {
        this.lastHealthRatio = lastHealthRatio;
    }

    @Override
    public boolean getHasSquidAir() {
        return this.hasSquidAir;
    }

    @Override
    public void setHasSquidAir(boolean hasSquidAir) {
        this.hasSquidAir = hasSquidAir;
    }

    @Override
    public int getSquidAir() {
        return this.squidAir;
    }

    @Override
    public void setSquidAir(int squidAir) {
        this.squidAir = squidAir;
    }

    @Override
    public float getLastHealth() {
        return this.lastHealth;
    }

    @Override
    public void setLastHealth(float lastHealth) {
        this.lastHealth = lastHealth;
    }

    @Override
    public void update(EntityPlayer player) {
        if (this.animation >= 0) {
            --this.animation;
        }
        if (this.animation == 16 && !player.field_70170_p.field_72995_K && !Metamorph.disableMorphAnimation.get()) {
            ((WorldServer)player.field_70170_p).func_180505_a(EnumParticleTypes.EXPLOSION_NORMAL, false, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 25, 0.5, 0.5, 0.5, 0.05, new int[0]);
            player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
        }
        if (!this.morph.isEmpty()) {
            AbstractMorph morph = this.morph.get();
            if (!Metamorph.disableHealth.get()) {
                this.setMaxHealth((EntityLivingBase)player, morph.settings.health);
            }
            morph.update((EntityLivingBase)player);
        }
    }

    protected void setHealth(EntityLivingBase target, float health) {
        IMorphing capability;
        if (Metamorph.disableHealth.get()) {
            return;
        }
        float maxHealth = target.func_110138_aP();
        float currentHealth = target.func_110143_aJ();
        float ratio = currentHealth / maxHealth;
        if (target instanceof EntityPlayer && (capability = Morphing.get((EntityPlayer)target)) != null) {
            if (maxHealth > 1.4E-43f) {
                capability.setLastHealthRatio(ratio);
            } else if (health > 1.4E-43f) {
                ratio = capability.getLastHealthRatio();
            }
        }
        this.setMaxHealth(target, health);
        float proportionalHealth = target.func_110138_aP() * ratio;
        target.func_70606_j(proportionalHealth <= 0.0f ? Float.MIN_VALUE : proportionalHealth);
    }

    protected void setMaxHealth(EntityLivingBase target, float health) {
        if (target.func_110138_aP() != health) {
            target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
        }
    }
}

