/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.creative;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IFocusedGuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Timer;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.creative.categories.MorphCategory;
import mchorse.metamorph.api.creative.categories.UserCategory;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphs;
import mchorse.metamorph.client.gui.creative.GuiMorphSection;
import mchorse.metamorph.client.gui.creative.GuiQuickEditor;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class GuiCreativeMorphsList
extends GuiElement {
    public Consumer<AbstractMorph> callback;
    private List<GuiAbstractMorph> editors;
    public GuiDelegateElement<GuiAbstractMorph> editor;
    public GuiElement bar;
    public GuiTextElement search;
    public GuiButtonElement edit;
    public GuiElement screen;
    public GuiQuickEditor quickEditor;
    public GuiCreativeMorphs morphs;
    private Timer timer = new Timer(100L);
    private Stack<NestedEdit> nestedEdits = new Stack();
    protected Keybind exitKey;

    public GuiCreativeMorphsList(Minecraft mc, Consumer<AbstractMorph> callback) {
        super(mc);
        this.callback = callback;
        this.editor = new GuiDelegateElement(mc, null);
        this.editor.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.screen = new GuiElement(mc);
        this.screen.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.quickEditor = new GuiQuickEditor(mc, this);
        this.quickEditor.flex().relative((GuiElement)this).x(1.0f, -200).wTo((IResizer)this.flex(), 1.0f).h(1.0f);
        this.quickEditor.setVisible(false);
        this.morphs = new GuiCreativeMorphs(mc, this);
        this.morphs.flex().relative((GuiElement)this).wh(1.0f, 1.0f).column(0).vertical().stretch().scroll();
        this.bar = new GuiElement(mc);
        this.search = new GuiTextElement(mc, this.morphs::setFilter);
        this.edit = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.edit"), b -> this.enterEditMorph());
        this.edit.setEnabled(false);
        this.edit.flex().w(60);
        this.bar.flex().relative((GuiElement)this.morphs).set(10.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -30).w(1.0f, -20).row(5).preferred(0).height(20);
        this.bar.add(new IGuiElement[]{this.search, this.edit});
        this.screen.add(new IGuiElement[]{this.morphs, this.bar, this.quickEditor});
        this.add(new IGuiElement[]{this.screen, new GuiDrawable(this::drawOverlay), this.editor});
        IKey category = IKey.lang((String)"metamorph.gui.creative.keys.category");
        this.exitKey = this.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.exit"), 1, this::exit).category(category).active(this::updateExitKey);
        this.reload();
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.edit"), 18, this::enterEditMorph).category(category);
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.quick"), 16, this::toggleQuickEdit).category(category);
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.focus"), 33, () -> GuiBase.getCurrent().focus((IFocusedGuiElement)this.search, true)).held(new int[]{29}).category(category);
    }

    public void reload() {
        this.morphs.setupSections(this, this::pickMorph);
        this.search.setText("");
    }

    public void exit() {
        if (this.isEditMode()) {
            this.exitEditMorph(this.nestedEdits.isEmpty(), false);
        } else {
            this.restoreEdit();
        }
        GuiBase.getCurrent().setContextMenu(null);
    }

    protected boolean updateExitKey() {
        return this.editor.delegate != null || !this.nestedEdits.isEmpty();
    }

    public Runnable showGlobalMorphs(AbstractMorph morph) {
        if (this.morphs.user.global.isEmpty() || morph == null) {
            return null;
        }
        return () -> {
            GuiSimpleContextMenu contextMenu = new GuiSimpleContextMenu(this.mc);
            for (UserCategory category : this.morphs.user.global) {
                contextMenu.action(IKey.str((String)category.getTitle()), () -> {
                    AbstractMorph added = morph.copy();
                    category.add(added);
                    this.setSelected(added);
                });
            }
            GuiBase.getCurrent().replaceContextMenu((GuiContextMenu)contextMenu);
        };
    }

    public void markDirty() {
        this.timer.mark();
    }

    public void disableDirty() {
        if (this.timer.enabled) {
            this.timer.enabled = false;
            this.morphs.syncSelected();
        }
    }

    public void toggleQuickEdit() {
        if (this.isEditMode() || !this.quickEditor.isVisible() && this.getSelected() == null) {
            return;
        }
        this.quickEditor.toggleVisible();
        if (this.quickEditor.isVisible()) {
            AbstractMorph morph = this.getSelected();
            if (!this.isSelectedMorphIsEditable()) {
                morph = this.morphs.copyToRecent(morph);
            }
            this.quickEditor.setMorph(morph, this.getMorphEditor(morph));
            this.morphs.flex().wTo((IResizer)this.quickEditor.flex());
        } else {
            this.morphs.flex().w(1.0f);
        }
        this.resize();
    }

    public boolean isNested() {
        return !this.nestedEdits.isEmpty();
    }

    public void nestEdit(AbstractMorph selected, boolean editing, Consumer<AbstractMorph> callback) {
        NestedEdit edit = new NestedEdit(this.morphs.filter, (AbstractMorph)((GuiAbstractMorph)this.editor.delegate).morph, ((GuiAbstractMorph)this.editor.delegate).toNBT(), this.callback, this.morphs.selected, editing);
        this.callback = callback;
        if (editing) {
            this.enterEditMorph(selected);
        } else {
            this.exitEditMorph(false, true);
            this.morphs.setFilter("");
            this.setSelected(selected);
        }
        this.nestedEdits.add(edit);
        this.updateExitKey();
    }

    public void restoreEdit() {
        if (this.nestedEdits.isEmpty()) {
            return;
        }
        NestedEdit edit = this.nestedEdits.pop();
        if (!edit.editing) {
            this.pickMorph(this.getSelected());
        }
        this.morphs.setFilter("");
        this.morphs.setSelectedDirect(edit.selected, edit.selectedMorph, edit.selectedCategory);
        this.callback = edit.callback;
        this.morphs.scrollTo();
        this.enterEditMorph(edit.editMorph);
        ((GuiAbstractMorph)this.editor.delegate).fromNBT(edit.data);
    }

    public boolean isEditMode() {
        return this.editor.delegate != null;
    }

    public void enterEditMorph() {
        AbstractMorph morph = this.getSelected();
        if (morph == null) {
            return;
        }
        if (!this.isSelectedMorphIsEditable() || !this.nestedEdits.isEmpty()) {
            morph = morph.copy();
            this.pickMorph(morph);
        }
        this.enterEditMorph(morph);
    }

    public void enterEditMorph(AbstractMorph morph) {
        if (morph == null) {
            return;
        }
        this.disableDirty();
        GuiAbstractMorph editor = this.getMorphEditor(morph);
        if (editor != null) {
            this.setEditor(editor);
        }
    }

    public void exitEditMorph(boolean add, boolean ignore) {
        if (!this.isEditMode()) {
            return;
        }
        Object edited = ((GuiAbstractMorph)this.editor.delegate).morph;
        if (!this.nestedEdits.isEmpty() && !ignore) {
            this.pickMorph((AbstractMorph)edited);
            this.restoreEdit();
            return;
        }
        ((GuiAbstractMorph)this.editor.delegate).finishEdit();
        this.morphs.syncSelected();
        if (add && edited != null && !this.isSelectedMorphIsEditable()) {
            this.setSelected((AbstractMorph)edited);
        }
        this.setEditor(null);
    }

    protected void setEditor(GuiAbstractMorph editor) {
        this.editor.setDelegate((GuiElement)editor);
        this.screen.setVisible(editor == null);
        this.updateExitKey();
    }

    public void finish() {
        int i = 0;
        while (this.isNested() || this.isEditMode()) {
            this.exit();
            ++i;
        }
        if (i > 0) {
            this.pickMorph(MorphUtils.copy(this.getSelected()));
        }
    }

    private GuiAbstractMorph getMorphEditor(AbstractMorph morph) {
        if (this.editors == null) {
            this.editors = new ArrayList<GuiAbstractMorph>();
            MorphManager.INSTANCE.registerMorphEditors(this.mc, this.editors);
        }
        for (GuiAbstractMorph editor : this.editors) {
            if (!editor.canEdit(morph)) continue;
            editor.setMorphs(this);
            editor.startEdit(morph);
            return editor;
        }
        return null;
    }

    public AbstractMorph getSelected() {
        Object morph;
        if (this.isEditMode() && (morph = ((GuiAbstractMorph)this.editor.delegate).morph) != null) {
            return morph;
        }
        return this.morphs.getSelected();
    }

    public void pickMorph(GuiMorphSection selected) {
        this.disableDirty();
        this.morphs.setSelectedDirect(selected);
        this.pickMorph(selected.morph);
        this.syncQuickEditor();
    }

    public void pickMorph(AbstractMorph morph) {
        this.edit.setEnabled(morph != null);
        if (this.callback != null) {
            this.callback.accept(morph);
        }
    }

    public AbstractMorph setSelected(AbstractMorph morph) {
        this.disableDirty();
        this.morphs.setSelected(morph);
        this.syncQuickEditor();
        morph = this.getSelected();
        this.edit.setEnabled(morph != null);
        return morph;
    }

    protected void syncQuickEditor() {
        if (this.quickEditor.isVisible()) {
            AbstractMorph morph = this.getSelected();
            if (morph != null && this.isSelectedMorphIsEditable()) {
                this.quickEditor.setMorph(morph, this.getMorphEditor(morph));
            } else {
                this.toggleQuickEdit();
            }
        }
    }

    protected boolean isSelectedMorphIsEditable() {
        return this.morphs.isSelectedMorphIsEditable();
    }

    public void draw(GuiContext context) {
        if (this.timer.checkReset()) {
            this.morphs.syncSelected();
        }
        super.draw(context);
    }

    private void drawOverlay(GuiContext context) {
        if (!this.isEditMode()) {
            boolean error;
            AbstractMorph morph = this.getSelected();
            String selected = morph != null ? morph.getDisplayName() : I18n.func_135052_a((String)"metamorph.gui.no_morph", (Object[])new Object[0]);
            boolean bl = error = morph != null && morph.errorRendering;
            if (error) {
                selected = I18n.func_135052_a((String)"metamorph.gui.morph_render_error", (Object[])new Object[0]);
            }
            Area area = this.search.area;
            int w = Math.max(this.font.func_78256_a(selected), morph != null ? this.font.func_78256_a(morph.name) : 0);
            if (morph != null && !morph.errorRendering) {
                Gui.func_73734_a((int)area.x, (int)(area.y - 27), (int)(area.x + w + 8), (int)area.y, (int)-587202560);
                this.font.func_175063_a(selected, (float)(area.x + 4), (float)(area.y - 23), -1);
                this.font.func_175063_a(morph.name, (float)(area.x + 4), (float)(area.y - 12), 0x888888);
            } else {
                Gui.func_73734_a((int)area.x, (int)(area.y - 16), (int)(area.x + w + 8), (int)area.y, (int)-587202560);
                this.font.func_175063_a(selected, (float)(area.x + 4), (float)(area.y - 12), error ? 16717875 : 0xFFFFFF);
            }
        }
        if (!this.isEditMode() && !this.search.field.func_146206_l() && this.search.field.func_146179_b().isEmpty()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.search", (Object[])new Object[0]), (float)(this.search.area.x + 5), (float)(this.search.area.y + 6), 0x888888);
        }
    }

    public static class NestedEdit {
        public String filter;
        public NBTTagCompound data;
        public Consumer<AbstractMorph> callback;
        public GuiMorphSection selected;
        public MorphCategory selectedCategory;
        public AbstractMorph selectedMorph;
        public AbstractMorph editMorph;
        public boolean editing;

        public NestedEdit(String filter, AbstractMorph editMorph, NBTTagCompound data, Consumer<AbstractMorph> callback, GuiMorphSection selected, boolean editing) {
            this.filter = filter;
            this.data = data;
            this.editMorph = editMorph;
            this.callback = callback;
            this.editing = editing;
            this.selected = selected;
            this.selectedCategory = selected == null ? null : selected.category;
            this.selectedMorph = selected == null ? null : selected.morph;
        }
    }
}

