/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.creative;

import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.tooltips.LabelTooltip;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.client.gui.creative.GuiMorphSection;
import mchorse.metamorph.client.gui.creative.GuiSelectorEditor;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.creative.PacketAcquireMorph;
import mchorse.metamorph.network.common.creative.PacketMorph;
import mchorse.metamorph.util.MMIcons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiCreativeScreen
extends GuiBase {
    private GuiSelectorEditor selectors;
    private GuiIconElement icon;
    private GuiIconElement copy;
    private GuiButtonElement morph;
    private GuiButtonElement acquire;
    private GuiButtonElement close;
    private GuiCreativeMorphsList pane;

    public GuiCreativeScreen(Minecraft mc) {
        this.selectors = new GuiSelectorEditor(mc);
        this.selectors.setVisible(false);
        this.icon = new GuiIconElement(mc, MMIcons.PROPERTIES, this::toggleEntitySelector);
        this.icon.tooltip(IKey.lang((String)"metamorph.gui.selectors.title"));
        this.icon.setVisible(Metamorph.proxy.canEditSelectors());
        this.copy = new GuiIconElement(mc, Icons.COPY, this::copyMorphCommand);
        this.copy.tooltip(IKey.lang((String)"metamorph.gui.creative.command"));
        this.morph = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.morph"), b -> {
            this.pane.finish();
            AbstractMorph morph = this.pane.getSelected();
            if (morph != null) {
                Dispatcher.sendToServer(new PacketMorph(morph));
                this.closeScreen();
            }
        });
        this.acquire = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.acquire"), b -> {
            this.pane.finish();
            AbstractMorph morph = this.pane.getSelected();
            if (morph != null) {
                Dispatcher.sendToServer(new PacketAcquireMorph(morph));
            }
        });
        this.close = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.close"), b -> this.closeScreen());
        this.pane = new GuiCreativeMorphsList(mc, this::setMorph);
        this.pane.setSelected(Morphing.get((EntityPlayer)mc.field_71439_g).getCurrentMorph());
        this.morph.flex().relative((IResizer)this.viewport).set(0.0f, 10.0f, 60.0f, 20.0f).x(1.0f, -200);
        this.acquire.flex().relative((GuiElement)this.morph).set(65.0f, 0.0f, 60.0f, 20.0f);
        this.close.flex().relative((GuiElement)this.acquire).set(65.0f, 0.0f, 60.0f, 20.0f);
        this.icon.flex().relative((GuiElement)this.morph).set(-18.0f, 2.0f, 16.0f, 16.0f);
        this.copy.flex().relative((GuiElement)this.icon).set(-20.0f, 0.0f, 16.0f, 16.0f);
        this.pane.flex().relative((IResizer)this.viewport).set(0.0f, 40.0f, 0.0f, 0.0f).w(1.0f, 0).h(1.0f, -40);
        this.selectors.flex().relative((IResizer)this.viewport).wTo((IResizer)this.pane.flex()).h(1.0f);
        this.root.add(new IGuiElement[]{this.pane, this.morph, this.acquire, this.close, this.selectors, this.icon, this.copy});
        this.root.keys().register(((LabelTooltip)this.icon.tooltip).label, 31, () -> this.icon.clickItself(this.context)).active(Metamorph.proxy.canEditSelectors()).category(this.pane.exitKey.category);
        this.root.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.acquire"), 30, () -> this.acquire.clickItself(this.context)).category(this.pane.exitKey.category).active(() -> !this.pane.isEditMode());
        this.root.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.morph"), 28, () -> this.morph.clickItself(this.context)).category(this.pane.exitKey.category).active(() -> !this.pane.isEditMode());
    }

    public boolean func_73868_f() {
        return Metamorph.pauseGUIInSP.get();
    }

    private void copyMorphCommand(GuiIconElement button) {
        GuiScreen.func_146275_d((String)GuiMorphSection.getMorphCommand(this.pane.getSelected()));
    }

    private void toggleEntitySelector(GuiIconElement button) {
        this.selectors.toggleVisible();
        if (this.selectors.isVisible()) {
            this.pane.flex().x(140).wTo((IResizer)this.root.flex(), 1.0f);
        } else {
            this.pane.flex().x(0).w(1.0f);
        }
        this.pane.resize();
        this.selectors.resize();
    }

    private void setMorph(AbstractMorph morph) {
        this.selectors.setMorph(morph);
        this.copy.setVisible(morph != null);
    }

    protected void closeScreen() {
        this.pane.finish();
        super.closeScreen();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiDraw.drawCustomBackground((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m);
        Gui.func_73734_a((int)this.pane.area.x, (int)0, (int)this.field_146294_l, (int)40, (int)-1442840576);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

