/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.render;

import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.entity.EntityMorph;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderMorph
extends RenderLivingBase<EntityMorph> {
    public RenderMorph(RenderManager manager, ModelBase model, float shadowSize) {
        super(manager, model, shadowSize);
    }

    protected boolean canRenderName(EntityMorph entity) {
        return super.func_177070_b((EntityLivingBase)entity) && entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i;
    }

    protected ResourceLocation getEntityTexture(EntityMorph entity) {
        return null;
    }

    public void doRender(EntityMorph entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.morph == null) {
            return;
        }
        this.field_76989_e = 0.35f;
        float range = ((float)entity.timer - partialTicks) / 30.0f;
        float alpha = 0.7f - (range <= 0.0f ? 0.0f : range) * 0.7f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)0.1f, (float)0.9f, (float)1.0f, (float)(alpha > 0.7f ? 0.7f : alpha));
        GlStateManager.func_179108_z();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float ticks = (float)entity.field_70173_aa + partialTicks;
        float rotation = ticks * 5.0f;
        GlStateManager.func_179137_b((double)x, (double)(y + Math.sin(ticks / 5.0f) * (double)0.1f + (double)0.2f), (double)z);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)alpha, (float)alpha, (float)alpha);
        MorphUtils.render(entity.morph, entity, 0.0, 0.0, 0.0, entityYaw, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179133_A();
        GlStateManager.func_179121_F();
    }

    protected void preRenderCallback(EntityMorph entity, float partialTickTime) {
        float scale = 1.0f - (float)entity.timer / 30.0f;
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        float x = 1.0f;
        float y = 1.0f;
        float z = 1.0f;
        x = MathHelper.func_76131_a((float)x, (float)0.0f, (float)1.5f);
        y = MathHelper.func_76131_a((float)y, (float)0.0f, (float)1.5f);
        z = MathHelper.func_76131_a((float)z, (float)0.0f, (float)1.5f);
        GlStateManager.func_179152_a((float)(x * scale), (float)(y * scale), (float)(z * scale));
    }

    public static class MorphFactory
    implements IRenderFactory<EntityMorph> {
        public Render<? super EntityMorph> createRenderFor(RenderManager manager) {
            return new RenderMorph(manager, null, 0.5f);
        }
    }
}

